/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.mixins;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.fakes.ServerPlayerEntityInterface;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.BlockPlacementHistory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3225.class})
public class ServerPlayerInteractionManagerMixin {
    @Shadow
    public class_3222 field_14008;

    @Inject(method={"tryBreakBlock"}, at={@At(value="INVOKE", target="net/minecraft/server/world/ServerWorld.removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void recordBreaking(class_2338 pos, CallbackInfoReturnable<Boolean> ci, class_2680 blockState, class_2586 blockEntity, class_2248 block) {
        BlockPlacementHistory history;
        if (OptionManager.blockPlacementHistory && (history = ((ServerPlayerEntityInterface)this.field_14008).getBlockPlacementHistory()) != null) {
            history.pushSingle(pos, blockState, class_2246.field_10124.method_9564(), blockEntity);
        }
    }

    @Inject(method={"interactItem"}, at={@At(value="HEAD")})
    public void onPlayerUseItem(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (OptionManager.enabledTools) {
            this.handleEnabledTools(player, stack);
        }
        if (OptionManager.clayBlockPlacer) {
            this.handleClayBlockPlacer(player, world, stack);
        }
    }

    private void handleEnabledTools(class_3222 player, class_1799 stack) {
        boolean carpetLoaded = FabricLoader.getInstance().isModLoaded("carpet");
        class_2168 source = CommandUtil.noreplySourceFor(this.field_14008.method_5671());
        if (stack.method_7909() == class_1802.field_8621 && carpetLoaded) {
            this.field_14008.field_13995.method_3734().method_9249(source, "/tick freeze");
        } else if (stack.method_7909() == class_1802.field_8606 && carpetLoaded) {
            this.field_14008.field_13995.method_3734().method_9249(source, String.format("/tick step %d", stack.method_7947()));
        } else if (stack.method_7909() == class_1802.field_22020) {
            for (class_3218 serverWorld : player.method_5682().method_3738()) {
                for (class_1297 e2 : serverWorld.method_18198(class_5575.method_31795(class_1297.class), e -> !(e instanceof class_3222))) {
                    e2.method_5650(class_1297.class_5529.field_26998);
                }
            }
        }
    }

    private void handleClayBlockPlacer(class_3222 player, class_1937 world, class_1799 stack) {
        if (stack.method_7909() != class_1802.field_8696 || !stack.method_7938()) {
            return;
        }
        String name = stack.method_7964().getString();
        try {
            BlockPlacementHistory history;
            class_2680 block = new class_2259(new StringReader(name), false).method_9678(false).method_9669();
            class_239 hit = player.method_5745(4.5, 0.0f, false);
            if (!(hit instanceof class_3965)) {
                return;
            }
            class_3965 blockHit = (class_3965)hit;
            class_2338 pos = blockHit.method_17777().method_10093(blockHit.method_17780());
            class_2680 prev = world.method_8320(pos);
            class_2586 prevBe = world.method_8321(pos);
            world.method_8652(pos, block, 26);
            if (OptionManager.blockPlacementHistory && (history = ((ServerPlayerEntityInterface)this.field_14008).getBlockPlacementHistory()) != null) {
                history.pushSingle(pos, prev, block, prevBe);
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }
}

