/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.OptionParser;

public class FloatParser
implements OptionParser<Float> {
    @Override
    public Float tryParse(String str) throws InvalidOptionException {
        try {
            return Float.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new InvalidOptionException("opt.err.rnum", new Object[0]);
        }
    }

    @Override
    public String serialize(Float val) {
        return Float.toString(val.floatValue());
    }

    public static class NaNablePositive
    extends Positive {
        @Override
        public Float tryParse(String str) throws InvalidOptionException {
            if ("NaN".equals(str)) {
                return Float.valueOf(Float.NaN);
            }
            return super.tryParse(str);
        }
    }

    public static class NonNegative
    extends FloatParser {
        @Override
        public Float tryParse(String str) throws InvalidOptionException {
            Float f = super.tryParse(str);
            if (f.floatValue() >= 0.0f) {
                return f;
            }
            throw new InvalidOptionException("opt.err.rnonnegative", new Object[0]);
        }
    }

    public static class Positive
    extends FloatParser {
        @Override
        public Float tryParse(String str) throws InvalidOptionException {
            Float f = super.tryParse(str);
            if (f.floatValue() > 0.0f) {
                return f;
            }
            throw new InvalidOptionException("opt.err.rpositive", new Object[0]);
        }
    }
}

