/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.OptionParser;
import net.minecraft.class_3230;
import net.minecraft.class_863;

public abstract class ListParser<T>
implements OptionParser<List<? extends T>> {
    public static final String EMPTY_LIST = "[]";
    protected final BiMap<String, T> elements;

    public ListParser(BiMap<String, T> elements) {
        this.elements = elements;
    }

    @Override
    public List<T> tryParse(String str) throws InvalidOptionException {
        if (EMPTY_LIST.equals(str) || str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (String elementStr : str.split(",")) {
            T element = this.parseElement(elementStr);
            if (element == null) {
                throw new InvalidOptionException("cmd.general.nodef", elementStr);
            }
            result.add(element);
        }
        return result;
    }

    protected T parseElement(String elementStr) throws InvalidOptionException {
        return (T)this.elements.get((Object)elementStr);
    }

    @Override
    public String serialize(List<? extends T> val) {
        if (val.isEmpty()) {
            return EMPTY_LIST;
        }
        StringBuilder sb = new StringBuilder();
        val.forEach(t -> sb.append(',').append((String)this.elements.inverse().get(t)));
        return sb.charAt(0) == ',' ? sb.deleteCharAt(0).toString() : sb.toString();
    }

    @Override
    public Set<String> createSuggestions() {
        HashSet<String> suggestions = new HashSet<String>(this.elements.keySet());
        suggestions.add(EMPTY_LIST);
        return suggestions;
    }

    public static class DebugRender
    extends ListParser<Either<Field, String>> {
        private static final ImmutableBiMap<String, Either<Field, String>> VANILLA_DEBUG_RENDERERS;

        public DebugRender() {
            super(VANILLA_DEBUG_RENDERERS);
        }

        @Override
        public List<Either<Field, String>> tryParse(String str) throws InvalidOptionException {
            return super.tryParse(str);
        }

        @Override
        protected Either<Field, String> parseElement(String elementStr) throws InvalidOptionException {
            if (MessMod.isDedicatedServerEnv()) {
                return Either.right((Object)elementStr);
            }
            return (Either)super.parseElement(elementStr);
        }

        static {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            if (!MessMod.isDedicatedServerEnv()) {
                Stream.of(class_863.class.getDeclaredFields()).filter(f -> class_863.class_864.class.isAssignableFrom(f.getType())).forEach(f -> {
                    try {
                        builder.put((Object)MessMod.INSTANCE.getMapping().namedField(f.getName()), (Object)Either.left((Object)f));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                });
            }
            VANILLA_DEBUG_RENDERERS = builder.build();
        }
    }

    public static class Ticket
    extends ListParser<class_3230<?>> {
        private static final ImmutableBiMap<String, class_3230<?>> VANILLA_TICKET_TYPES;

        public Ticket() {
            super(VANILLA_TICKET_TYPES);
        }

        static {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            Stream.of(class_3230.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getType().equals(class_3230.class)).map(f -> {
                try {
                    return (class_3230)f.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }).forEach(t -> builder.put((Object)t.toString(), t));
            VANILLA_TICKET_TYPES = builder.build();
        }
    }
}

