/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import lovexyn0827.mess.options.Label;
import lovexyn0827.mess.options.Option;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.options.OptionParser;
import lovexyn0827.mess.util.i18n.I18N;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;

public final class OptionWrapper {
    final Field field;
    final String name;
    final OptionParser<?> parser;
    final Option option;

    OptionWrapper(Field f) {
        this.field = f;
        this.name = f.getName();
        this.option = f.getAnnotation(Option.class);
        this.parser = OptionParser.of(this.option);
    }

    public Object get() {
        try {
            return this.field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Object o, @Nullable CommandContext<class_2168> ct) {
        try {
            this.field.set(null, o);
            OptionManager.CustomOptionApplicator action = OptionManager.CUSTOM_APPLICATION_BEHAVIORS.get(this.name);
            if (action != null) {
                action.onOptionUpdate(o, ct);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return I18N.translate("opt." + this.name + ".desc");
    }

    public boolean isSupportedInCurrentEnv() {
        EnvType currentEnv = FabricLoader.getInstance().getEnvironmentType();
        for (EnvType env : this.option.environment()) {
            if (env != currentEnv) continue;
            return true;
        }
        return false;
    }

    public String getDefaultValue() {
        return this.option.defaultValue();
    }

    public SuggestionProvider<class_2168> getSuggestions() {
        return (ct, b) -> {
            this.parser.createSuggestions().forEach(arg_0 -> ((SuggestionsBuilder)b).suggest(arg_0));
            for (String s : this.option.suggestions()) {
                b.suggest(s);
            }
            b.suggest(this.getDefaultValue());
            return b.buildFuture();
        };
    }

    public boolean isExperimental() {
        return this.option.experimental();
    }

    public boolean isDeprecated() {
        return this.option.deprecated();
    }

    public boolean globalOnly() {
        return this.option.globalOnly();
    }

    public Label[] labels() {
        return this.option.label();
    }
}

