/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Random;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.rendering.RenderedBitmap;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3175;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4638;
import net.minecraft.class_4651;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FlowerFieldRenderer {
    private static final Random RANDOM = new Random();
    private static final Object2IntMap<class_2356> COLOR_BY_FLOWER = new Object2IntOpenHashMap();
    private static final int DEFAULT_Y = 0;
    private final MinecraftServer server;

    public FlowerFieldRenderer(MinecraftServer server) {
        this.server = server;
    }

    public void tick() {
        if (!OptionManager.flowerFieldRenderer) {
            return;
        }
        this.server.method_3760().method_14571().forEach(this::handlePlayer);
    }

    private void handlePlayer(class_3222 player) {
        class_3218 sw = player.method_14220();
        class_1792 holding = player.method_6030().method_7909();
        boolean restricted = holding instanceof class_1747 && ((class_1747)holding).method_7711() instanceof class_2356;
        int radius = OptionManager.flowerFieldRendererRadius;
        class_2338 center = player.method_24515();
        class_2338.class_2339 cur = center.method_25503().method_10100(-radius, 0, -radius);
        int width = 2 * radius;
        int maxY = 0;
        Int2ObjectOpenHashMap bitmapsByLayer = new Int2ObjectOpenHashMap();
        boolean singleLayer = OptionManager.flowerFieldRendererSingleLayer;
        for (int dx = -radius; dx < radius; ++dx) {
            for (int dz = -radius; dz < radius; ++dz) {
                int color;
                cur.method_25504((class_2382)center, dx, 0, dz);
                class_2338 top = sw.method_8598(class_2902.class_2903.field_13197, (class_2338)cur);
                int y2 = top.method_10264();
                maxY = y2 > maxY ? y2 : maxY;
                int[] bitmap2 = (int[])bitmapsByLayer.computeIfAbsent(singleLayer ? 0 : top.method_10264(), i -> new int[width * width]);
                int offset = (dz + radius) * width + dx + radius;
                class_2356 flower = FlowerFieldRenderer.getFlowerAt(sw, top);
                if (flower == null || restricted && flower.method_8389() != holding) continue;
                bitmap2[offset] = color = COLOR_BY_FLOWER.getInt((Object)flower) | 0xFF000000;
            }
        }
        if (singleLayer) {
            class_243 origin = new class_243((double)(center.method_10263() - radius), (double)maxY + 0.01, (double)(center.method_10260() - radius));
            int[] bitmap3 = (int[])bitmapsByLayer.get(0);
            MessMod.INSTANCE.shapeSender.addShape(new RenderedBitmap(bitmap3, 1.0, width, width, class_2350.class_2351.field_11052, origin, 0, sw.method_8510()), (class_5321<class_1937>)sw.method_27983(), player);
        } else {
            bitmapsByLayer.forEach((y, bitmap) -> {
                class_243 origin = new class_243((double)(center.method_10263() - radius), (double)y.intValue() + 0.01, (double)(center.method_10260() - radius));
                MessMod.INSTANCE.shapeSender.addShape(new RenderedBitmap((int[])bitmap, 1.0, width, width, class_2350.class_2351.field_11052, origin, 0, sw.method_8510()), (class_5321<class_1937>)sw.method_27983(), player);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static class_2356 getFlowerAt(class_3218 sw, class_2338 cur) {
        List flowerGenerators = ((class_1959)sw.method_23753(cur).comp_349()).method_30970().method_30982();
        if (flowerGenerators.isEmpty()) {
            return null;
        }
        class_2975 fGenConf = (class_2975)flowerGenerators.get(0);
        class_4638 patchConf = (class_4638)fGenConf.comp_333();
        class_3037 conf = ((class_2975)((class_6796)patchConf.comp_155().comp_349()).comp_334().comp_349()).comp_333();
        if (conf instanceof class_3175) {
            class_4651 fGen;
            class_4651 class_46512 = fGen = ((class_3175)conf).comp_156();
            synchronized (class_46512) {
                class_2248 block = fGen.method_23455(RANDOM, cur).method_26204();
                return block instanceof class_2356 ? (class_2356)block : null;
            }
        }
        return null;
    }

    static {
        long count = class_2378.field_11146.method_10220().filter(class_2356.class::isInstance).count();
        float step = 6.0f / (float)count;
        int[] i = new int[1];
        class_2378.field_11146.method_10220().filter(class_2356.class::isInstance).forEach(f -> {
            int n = i[0];
            i[0] = n + 1;
            int rgb = class_3532.method_15369((float)(step * (float)n), (float)1.0f, (float)1.0f);
            COLOR_BY_FLOWER.put((Object)((class_2356)f), rgb);
        });
    }
}

