/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.atomic.AtomicInteger;
import lovexyn0827.mess.rendering.Shape;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5321;

public class RenderedBitmap
extends Shape {
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private final int[] pixels;
    private final double pixelSize;
    private final class_2350.class_2351 oriention;
    private final class_243 origin;
    private final int height;
    private final int width;
    @Environment(value=EnvType.CLIENT)
    private class_1043 texture;
    @Environment(value=EnvType.CLIENT)
    private class_1921 layer;
    @Environment(value=EnvType.CLIENT)
    private boolean uploaded = false;

    public RenderedBitmap(int[] pixels, double pixelSize, int height, int width, class_2350.class_2351 oriention, class_243 origin, int life, long gt) {
        super(0, 0, life, gt);
        this.height = height;
        this.width = width;
        this.pixels = pixels;
        this.pixelSize = pixelSize;
        this.oriention = oriention;
        this.origin = origin;
    }

    @Environment(value=EnvType.CLIENT)
    private void uploadTexture() {
        int pixelCnt = this.width * this.height;
        class_1043 texture = new class_1043(this.width, this.height, true);
        class_1011 im = texture.method_4525();
        for (int i = 0; i < pixelCnt; ++i) {
            im.method_4305(i % this.width, i / this.width, this.pixels[i]);
        }
        class_1060 tm = class_310.method_1551().method_1531();
        class_2960 textureId = tm.method_4617("messmod_bitmap_" + NEXT_ID.getAndIncrement(), texture);
        texture.method_4524();
        this.texture = texture;
        this.layer = class_1921.method_23028((class_2960)textureId);
    }

    @Override
    protected void renderFaces(class_4587 matrices, class_289 tessellator, class_287 builder, double cx, double cy, double cz, float partialTick) {
        if (!this.uploaded) {
            this.uploadTexture();
            this.uploaded = true;
        }
        RenderSystem.enableTexture();
        this.texture.method_23207();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        double x0 = this.origin.field_1352 - cx;
        double y0 = this.origin.field_1351 - cy;
        double z0 = this.origin.field_1350 - cz;
        double width = (double)this.width * this.pixelSize;
        double height = (double)this.height * this.pixelSize;
        switch (this.oriention) {
            case field_11048: {
                builder.method_22912(x0, y0, z0).method_22913(0.0f, 0.0f).method_1344();
                builder.method_22912(x0, y0, z0 + width).method_22913(0.0f, 1.0f).method_1344();
                builder.method_22912(x0, y0 + height, z0 + width).method_22913(1.0f, 1.0f).method_1344();
                builder.method_22912(x0, y0 + height, z0).method_22913(1.0f, 0.0f).method_1344();
                break;
            }
            case field_11052: {
                builder.method_22912(x0, y0, z0).method_22913(0.0f, 0.0f).method_1344();
                builder.method_22912(x0, y0, z0 + height).method_22913(0.0f, 1.0f).method_1344();
                builder.method_22912(x0 + width, y0, z0 + height).method_22913(1.0f, 1.0f).method_1344();
                builder.method_22912(x0 + width, y0, z0).method_22913(1.0f, 0.0f).method_1344();
                break;
            }
            case field_11051: {
                builder.method_22912(x0, y0, z0).method_22913(0.0f, 0.0f).method_1344();
                builder.method_22912(x0, y0, z0 + width).method_22913(0.0f, 1.0f).method_1344();
                builder.method_22912(x0, y0 + height, z0 + width).method_22913(1.0f, 1.0f).method_1344();
                builder.method_22912(x0, y0 + height, z0).method_22913(1.0f, 0.0f).method_1344();
            }
        }
        tessellator.method_1350();
        RenderSystem.disableTexture();
    }

    @Override
    protected void renderLines(class_4587 matrices, class_289 tessellator, class_287 buffer, double cameraX, double cameraY, double cameraZ, float partialTick) {
    }

    @Override
    protected boolean shouldRender(class_5321<class_1937> dimensionType) {
        return true;
    }

    @Override
    protected class_2487 toTag(class_2487 tag) {
        super.toTag(tag);
        tag.method_10549("PixelSize", this.pixelSize);
        tag.method_10549("X", this.origin.field_1352);
        tag.method_10549("Y", this.origin.field_1351);
        tag.method_10549("Z", this.origin.field_1350);
        tag.method_10569("Oriention", this.oriention.ordinal());
        tag.method_10569("Width", this.width);
        tag.method_10569("Height", this.height);
        tag.method_10539("Pixels", this.pixels);
        return tag;
    }

    public static RenderedBitmap fromTag(class_2487 tag) {
        return new RenderedBitmap(tag.method_10561("Pixels"), tag.method_10574("PixelSize"), tag.method_10550("Height"), tag.method_10550("Width"), class_2350.class_2351.values()[tag.method_10550("Oriention")], new class_243(tag.method_10574("X"), tag.method_10574("Y"), tag.method_10574("Z")), tag.method_10550("Life"), tag.method_10537("GT"));
    }

    @Override
    protected void close() {
        if (this.texture != null) {
            this.texture.close();
        }
    }
}

