/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering.hud.data;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.rendering.hud.HudType;
import lovexyn0827.mess.rendering.hud.data.BuiltinHudInfo;
import lovexyn0827.mess.rendering.hud.data.HudLine;
import lovexyn0827.mess.rendering.hud.data.LocalDefaultHudDataStorage;
import lovexyn0827.mess.rendering.hud.data.RemoteHudDataSender;
import lovexyn0827.mess.util.ListenedField;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.WrappedPath;
import lovexyn0827.mess.util.access.AccessingPath;
import net.minecraft.class_1297;
import net.minecraft.server.MinecraftServer;

public interface HudDataSender {
    public void updateData(class_1297 var1);

    public Collection<HudLine> getLines();

    default public Collection<HudLine> getCustomLines() {
        return this.getLines().stream().filter(l -> !(l instanceof BuiltinHudInfo)).collect(Collectors.toList());
    }

    default public boolean hasDuplication(HudLine line) {
        return this.getCustomLines().stream().anyMatch(l0 -> l0.getName().equals(line.getName()) || l0.equals(line));
    }

    default public boolean addCustomLine(HudLine line) {
        if (this.hasDuplication(line)) {
            return false;
        }
        this.getCustomLines().add(line);
        return true;
    }

    default public boolean removeCustomLine(String name) {
        return this.getCustomLines().removeIf(line -> line.getName().equals(name));
    }

    default public boolean addField(Class<?> cl, String field) {
        return this.addField(cl, field, field, AccessingPath.DUMMY);
    }

    default public boolean addField(Class<?> cl, String field, String name, AccessingPath path) {
        if ("-THIS-".equals(field)) {
            return this.addCustomLine(new WrappedPath(path, name));
        }
        Field f = Reflection.getFieldFromNamed(cl, field);
        ListenedField lf = new ListenedField(f, path, name);
        return this.addCustomLine(lf);
    }

    default public List<HudLine> getListenedFields() {
        return this.getCustomLines().stream().collect(Collectors.toList());
    }

    public static HudDataSender createHudDataSenderer(HudType type, MinecraftServer server) {
        if (type == HudType.SIDEBAR) {
            throw new IllegalArgumentException("Data senderer of sidebars cannot be created here!");
        }
        if (MessMod.isDedicatedEnv()) {
            return new RemoteHudDataSender(server, type, true);
        }
        switch (type) {
            case TARGET: 
            case SERVER_PLAYER: 
            case CLIENT_PLAYER: {
                return new LocalDefaultHudDataStorage();
            }
        }
        throw new IllegalArgumentException();
    }
}

