/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util;

import com.mojang.brigadier.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class NameFilter
implements Predicate<String> {
    private final Predicate<String> nameFilter;

    private NameFilter(Predicate<String> nameFilter) {
        this.nameFilter = nameFilter;
    }

    @Override
    public boolean test(String s) {
        return this.nameFilter.test(s);
    }

    public <T extends Enum<?>> Set<T> filter(Class<? extends T> clazz) {
        HashSet<Enum> filtered = new HashSet<Enum>();
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!this.test(e.name())) continue;
            filtered.add(e);
        }
        return filtered;
    }

    public <T> Set<T> filter(Iterable<T> c) {
        HashSet<T> filtered = new HashSet<T>();
        for (T e : c) {
            if (!this.test(e.toString())) continue;
            filtered.add(e);
        }
        return filtered;
    }

    public <T> Set<T> filter(Iterable<T> c, Function<T, String> toString) {
        HashSet<T> filtered = new HashSet<T>();
        for (T e : c) {
            if (!this.test(toString.apply(e))) continue;
            filtered.add(e);
        }
        return filtered;
    }

    public <K, V> Map<K, V> filterByKey(Map<K, V> m, Function<K, String> toString) {
        HashMap<K, V> filtered = new HashMap<K, V>();
        for (Map.Entry<K, V> e : m.entrySet()) {
            if (!this.test(toString.apply(e.getKey()))) continue;
            filtered.put(e.getKey(), e.getValue());
        }
        return filtered;
    }

    public static NameFilter compile(String in) {
        if ("*".equals(in)) {
            return new NameFilter(n -> true);
        }
        if (!in.contains("*") && !in.contains("?")) {
            return new NameFilter(in::equals);
        }
        StringReader sr = new StringReader(in);
        ArrayList<Node> nodes = new ArrayList<Node>();
        StringBuilder sb = new StringBuilder();
        block4: while (sr.canRead()) {
            char c = sr.read();
            switch (c) {
                case '*': {
                    if (sb.length() != 0) {
                        nodes.add(new TextNode(sb.toString()));
                        sb = new StringBuilder();
                    }
                    nodes.add(AsteriskNode.INSTANCE);
                    continue block4;
                }
                case '?': {
                    if (sb.length() != 0) {
                        nodes.add(new TextNode(sb.toString()));
                        sb = new StringBuilder();
                    }
                    int count = 1;
                    while (sr.canRead() && sr.peek() == '?') {
                        sr.skip();
                        ++count;
                    }
                    nodes.add(new QmNode(count));
                    continue block4;
                }
            }
            sb.append(c);
        }
        if (sb.length() != 0) {
            nodes.add(new TextNode(sb.toString()));
        }
        return new NameFilter(s -> {
            ListIterator itr = nodes.listIterator();
            int l = s.length();
            int i = 0;
            while (itr.hasNext()) {
                Node n = (Node)itr.next();
                block0 : switch (n.type()) {
                    case ASTERISK: {
                        if (itr.hasNext()) {
                            n = (Node)itr.next();
                            if (n.type() == NodeType.TEXT) {
                                TextNode tn = (TextNode)n;
                                char start = tn.text.charAt(0);
                                while (i < l && s.charAt(i) != start) {
                                    ++i;
                                }
                                if (i == l) {
                                    return false;
                                }
                                while (i + tn.length - 1 < l) {
                                    if (s.regionMatches(i, tn.text, 0, tn.length)) {
                                        i += tn.length;
                                        break block0;
                                    }
                                    ++i;
                                }
                                return false;
                            }
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    case QM: {
                        QmNode qmn = (QmNode)n;
                        if (i + qmn.length - 1 >= l) {
                            return false;
                        }
                        i += qmn.length;
                        break;
                    }
                    case TEXT: {
                        TextNode tn = (TextNode)n;
                        if (s.regionMatches(i, tn.text, 0, tn.length)) {
                            i += tn.length;
                            break;
                        }
                        return false;
                    }
                }
            }
            return true;
        });
    }

    private static final class TextNode
    implements Node {
        protected final int length;
        protected final String text;

        protected TextNode(String text) {
            this.length = text.length();
            this.text = text;
        }

        @Override
        public NodeType type() {
            return NodeType.TEXT;
        }
    }

    private static enum AsteriskNode implements Node
    {
        INSTANCE;


        @Override
        public NodeType type() {
            return NodeType.ASTERISK;
        }
    }

    private static final class QmNode
    implements Node {
        protected final int length;

        protected QmNode(int length) {
            this.length = length;
        }

        @Override
        public NodeType type() {
            return NodeType.QM;
        }
    }

    private static interface Node {
        public NodeType type();
    }

    private static enum NodeType {
        ASTERISK,
        QM,
        TEXT;

    }
}

