/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public enum TickingPhase {
    WEATHER_CYCLE(false),
    CHUNK(false),
    SCHEDULED_TICK(false),
    VILLAGE(false),
    BLOCK_EVENT(false),
    ENTITY(false),
    TILE_ENTITY(false),
    TICKED_ALL_WORLDS(true),
    SERVER_TASKS(true);

    private final List<Event> events = Lists.newArrayList();
    public final boolean notInAnyWorld;

    private TickingPhase(boolean notInAnyWorld) {
        this.notInAnyWorld = notInAnyWorld;
    }

    public void triggerEvents(@Nullable class_3218 world) {
        this.events.forEach(e -> e.trigger(this, world));
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public void removeEvent(Event event) {
        this.events.add(event);
    }

    public static void addEventToAll(Event event) {
        for (TickingPhase phase : TickingPhase.values()) {
            phase.addEvent(event);
        }
    }

    public static void removeAllEvents() {
        for (TickingPhase phase : TickingPhase.values()) {
            phase.events.clear();
        }
    }

    public static RequiredArgumentBuilder<class_2168, String> commandArg() {
        return class_2170.method_9244((String)"whereToUpdate", (ArgumentType)StringArgumentType.string()).suggests((ct, b) -> {
            for (TickingPhase phase : TickingPhase.values()) {
                b.suggest(phase.name());
            }
            return b.buildFuture();
        });
    }

    public static interface Event {
        public void trigger(TickingPhase var1, @Nullable class_3218 var2);
    }
}

