/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import java.util.Objects;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.NodeCompiler;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.TypeInsnNode;

public class ClassCastNode
extends Node {
    private final Class<?> castTo;

    public ClassCastNode(String className) {
        try {
            String runtimtClassName = MessMod.INSTANCE.getMapping().srgClass(className.replace('/', '.'));
            this.castTo = Class.forName(runtimtClassName);
        }
        catch (ClassNotFoundException e) {
            TranslatableException e1 = new TranslatableException("exp.noclass", className);
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    Object access(Object previous) throws AccessingFailureException {
        try {
            return this.castTo.cast(previous);
        }
        catch (ClassCastException e) {
            throw AccessingFailureException.createWithArgs(FailureCause.CAST, this, e, previous.getClass().getCanonicalName(), this.castTo.getCanonicalName());
        }
    }

    @Override
    protected java.lang.reflect.Type resolveOutputType(java.lang.reflect.Type lastOutType) throws AccessingFailureException, InvalidLiteralException {
        return this.castTo;
    }

    public int hashCode() {
        return Objects.hash(this.castTo);
    }

    public String toString() {
        return "(" + this.castTo.getCanonicalName().replace('.', '/') + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassCastNode other = (ClassCastNode)obj;
        return Objects.equals(this.castTo, other.castTo);
    }

    @Override
    NodeCompiler getCompiler() {
        this.ensureInitialized();
        return ctx -> {
            InsnList insns = new InsnList();
            insns.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(this.castTo)));
            ctx.endNode(this.castTo);
            return insns;
        };
    }
}

