/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.google.common.collect.ImmutableCollection;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.BytecodeHelper;
import lovexyn0827.mess.util.access.CompilationException;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.NodeCompiler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

final class ElementNode
extends Node {
    private int index;

    ElementNode(int index) {
        this.index = index;
    }

    @Override
    Object access(Object previous) throws AccessingFailureException {
        if (previous.getClass().isArray()) {
            try {
                if (this.index >= 0) {
                    return Array.get(previous, this.index);
                }
                return Array.get(previous, Array.getLength(previous) + this.index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw AccessingFailureException.create(FailureCause.OUT_OF_BOUND, (Node)this);
            }
        }
        if (previous instanceof Collection) {
            Collection c = (Collection)previous;
            if (this.index < c.size()) {
                Iterator itr = c.iterator();
                for (int i = 0; i < this.index; ++i) {
                    itr.next();
                }
                return itr.next();
            }
            throw AccessingFailureException.create(FailureCause.OUT_OF_BOUND, (Node)this);
        }
        throw AccessingFailureException.createWithArgs(FailureCause.INV_LAST, this, null, this);
    }

    public int hashCode() {
        return this.index ^ (this.outputType != null ? this.outputType.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ElementNode.class != obj.getClass()) {
            return false;
        }
        ElementNode other = (ElementNode)obj;
        return this.index == other.index && (this.outputType == null ? other.outputType == null : this.outputType.equals(other.outputType));
    }

    public String toString() {
        return "[" + Integer.toString(this.index) + "]";
    }

    @Override
    boolean canFollow(Node n) {
        Type t = n.outputType;
        return t instanceof Class && (((Class)t).isArray() || Collection.class.isAssignableFrom((Class)t));
    }

    @Override
    protected Type resolveOutputType(Type lastOutType) {
        Class cl;
        if (lastOutType instanceof ParameterizedType) {
            Type typeArg = ((ParameterizedType)lastOutType).getActualTypeArguments()[0];
            return typeArg;
        }
        if (lastOutType instanceof Class && (cl = (Class)lastOutType).isArray()) {
            Class<?> compType = cl.getComponentType();
            return compType;
        }
        return Object.class;
    }

    @Override
    Node createCopyForInput(Object input) {
        ElementNode node = new ElementNode(this.index);
        node.ordinary = this.ordinary;
        return node;
    }

    @Override
    boolean isWrittable() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void write(Object writeTo, Object newValue) throws AccessingFailureException {
        if (ImmutableCollection.class.isAssignableFrom(Reflection.getRawType(this.inputType))) {
            throw AccessingFailureException.create(FailureCause.NOT_WRITTABLE, (Node)this);
        }
        if (writeTo.getClass().isArray()) {
            try {
                if (this.index >= 0) {
                    Array.set(writeTo, this.index, newValue);
                    return;
                }
                Array.set(writeTo, Array.getLength(writeTo) + this.index, newValue);
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw AccessingFailureException.create(FailureCause.OUT_OF_BOUND, (Node)this);
            }
        }
        if (!(writeTo instanceof Collection)) throw AccessingFailureException.createWithArgs(FailureCause.INV_LAST, this, null, this);
        if (!(writeTo instanceof List)) throw AccessingFailureException.create(FailureCause.NOT_WRITTABLE, (Node)this);
        if (newValue != null && !Reflection.getRawType(this.outputType).isAssignableFrom(newValue.getClass())) throw AccessingFailureException.createWithArgs(FailureCause.INV_LAST_W, this, null, this, newValue);
        try {
            ((List)writeTo).add(this.index, newValue);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            throw AccessingFailureException.create(FailureCause.OUT_OF_BOUND, (Node)this);
        }
        catch (UnsupportedOperationException e) {
            throw AccessingFailureException.create(FailureCause.NOT_WRITTABLE, (Node)this);
        }
    }

    @Override
    NodeCompiler getCompiler() {
        return ctx -> {
            Class<?> out;
            Type inType = ctx.getLastOutputType();
            InsnList insns = new InsnList();
            Class<?> rawType = Reflection.getRawType(inType);
            if (rawType.isArray()) {
                BytecodeHelper.appendArrayElementLoader(insns, this.index, rawType.getComponentType());
                out = rawType.getComponentType();
            } else if (Collection.class.isAssignableFrom(rawType)) {
                boolean isList = List.class.isAssignableFrom(rawType);
                insns.add((AbstractInsnNode)new TypeInsnNode(192, isList ? "java/util/List" : "java/util/Collection"));
                insns.add((AbstractInsnNode)new InsnNode(89));
                insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Collection", "size", "()I"));
                BytecodeHelper.appendIntegerLoader(insns, this.index);
                if (isList) {
                    insns.add((AbstractInsnNode)new InsnNode(90));
                }
                LabelNode ifInBound = new LabelNode();
                insns.add((AbstractInsnNode)new JumpInsnNode(163, ifInBound));
                BytecodeHelper.appendAccessingFailureException(insns, FailureCause.OUT_OF_BOUND);
                insns.add((AbstractInsnNode)ifInBound);
                if (isList) {
                    insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "get", "(I)Ljava/lang/Object;"));
                } else {
                    insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Collection", "iterator", "()Ljava/util/Iterator;"));
                    if (this.index >= 0 && this.index <= -1) {
                        for (int i = 0; i < this.index; ++i) {
                            insns.add((AbstractInsnNode)new InsnNode(89));
                            insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Iterator", "next", "()Ljava/lang/Object;"));
                            insns.add((AbstractInsnNode)new InsnNode(87));
                        }
                        insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Iterator", "next", "()Ljava/lang/Object;"));
                    } else {
                        int var = ctx.allocateLocalVar();
                        BytecodeHelper.appendIntegerLoader(insns, this.index);
                        insns.add((AbstractInsnNode)new VarInsnNode(54, var));
                        insns.add((AbstractInsnNode)new InsnNode(1));
                        LabelNode beginLoop = new LabelNode();
                        insns.add((AbstractInsnNode)beginLoop);
                        insns.add((AbstractInsnNode)new InsnNode(87));
                        insns.add((AbstractInsnNode)new InsnNode(89));
                        insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Iterator", "next", "()Ljava/lang/Object;"));
                        insns.add((AbstractInsnNode)new IincInsnNode(var, -1));
                        insns.add((AbstractInsnNode)new VarInsnNode(21, var));
                        insns.add((AbstractInsnNode)new JumpInsnNode(156, beginLoop));
                    }
                }
                out = Reflection.getTypeArgOrObject(inType, 0);
            } else {
                throw new CompilationException(FailureCause.INV_LAST, this);
            }
            ctx.endNode(out);
            return insns;
        };
    }
}

