/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.command.VariableCommand;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Literal<T> {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^((?:\\+|-)?[0-9]*(?:\\.[0-9]*)?|(?:\\+|-)?Infinity|NaN)(?:D|F|L|I)?$");
    @NotNull
    protected final String stringRepresentation;
    protected boolean compiled;

    protected Literal(String strRep) {
        Objects.requireNonNull(strRep);
        this.stringRepresentation = strRep;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stringRepresentation == null ? 0 : this.stringRepresentation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        return this.compiled && other.compiled && this.stringRepresentation.equals(other.stringRepresentation);
    }

    public String toString() {
        return this.stringRepresentation;
    }

    @Nullable
    public abstract T get(@Nullable Type var1) throws InvalidLiteralException;

    public static Literal<?> parse(String strRep) throws CommandSyntaxException {
        switch (strRep.charAt(0)) {
            case '\"': {
                return new StringL(strRep);
            }
            case 'E': {
                if (strRep.charAt(1) != '+') break;
                return new EnumL(strRep);
            }
            case 'S': {
                if (strRep.charAt(1) != '+') break;
                return new StaticFieldL(strRep);
            }
            case 'C': {
                if (strRep.charAt(1) != '+') break;
                return new ClassL(strRep);
            }
            case 'A': {
                if (strRep.charAt(1) != '+') break;
                return new ArrayL(strRep);
            }
            case '[': {
                return new BlockPosL(strRep);
            }
            case '(': {
                return new Vec3dL(strRep);
            }
            case 'V': {
                if (strRep.charAt(1) != '+') break;
                return new VarL(strRep);
            }
            default: {
                boolean bool;
                Matcher matcher = NUMBER_PATTERN.matcher(strRep);
                if ("null".equals(strRep)) {
                    return new NullL();
                }
                if (matcher.matches()) {
                    String numStr = matcher.group(1);
                    switch (strRep.charAt(strRep.length() - 1)) {
                        case 'D': {
                            return new DoubleL(numStr);
                        }
                        case 'F': {
                            return new FloatL(numStr);
                        }
                        case 'L': {
                            return new LongL(numStr);
                        }
                        case 'I': {
                            return new IntL(numStr);
                        }
                    }
                    if (strRep.contains(".")) {
                        return new DoubleL(strRep);
                    }
                    return new IntL(strRep);
                }
                if ("true".equals(strRep)) {
                    bool = true;
                } else if ("false".equals(strRep)) {
                    bool = false;
                } else {
                    throw new TranslatableException("exp.invliteral", strRep);
                }
                return new Literal<Boolean>(strRep){

                    @Override
                    public Boolean get(Type type) {
                        return bool;
                    }
                };
            }
        }
        throw new TranslatableException("exp.invliteral", strRep);
    }

    protected Literal<?> recreate() {
        return this;
    }

    public boolean isStatic() {
        return this.compiled;
    }

    public String serialize() {
        return this.stringRepresentation;
    }

    static class StringL
    extends Literal<String> {
        private String string;

        protected StringL(String strRep) {
            super(strRep);
            this.string = strRep.substring(1, strRep.length() - 1);
            this.compiled = true;
        }

        @Override
        public String get(Type clazz) {
            return this.string;
        }
    }

    static class EnumL
    extends Literal<Enum<?>> {
        private Enum<?> enumConstant;

        protected EnumL(String strRep) {
            super(strRep);
        }

        @Override
        public Enum<?> get(Type clazz) throws InvalidLiteralException {
            if (this.compiled) {
                return this.enumConstant;
            }
            if (clazz == null) {
                throw InvalidLiteralException.createWithArgs(FailureCause.UNCERTAIN_CLASS, this, null, this.stringRepresentation);
            }
            Class<?> cl = Reflection.getRawType(clazz);
            if (cl != null && cl.isEnum()) {
                String f = MessMod.INSTANCE.getMapping().srgField(cl.getName(), this.stringRepresentation);
                try {
                    Object e = Enum.valueOf(cl, f);
                    this.enumConstant = e;
                    this.compiled = true;
                    return e;
                }
                catch (IllegalArgumentException e) {
                    throw InvalidLiteralException.createWithArgs(FailureCause.NO_FIELD, this, null, this.stringRepresentation, clazz.getTypeName());
                }
            }
            throw InvalidLiteralException.createWithArgs(FailureCause.UNCERTAIN_CLASS, this, null, this.stringRepresentation);
        }

        @Override
        protected Literal<?> recreate() {
            return new EnumL(this.stringRepresentation);
        }
    }

    static class StaticFieldL
    extends Literal<Object> {
        private Object fieldVal;

        protected StaticFieldL(String strRep) {
            super(strRep);
        }

        @Override
        @NotNull
        public Object get(Type clazz) throws InvalidLiteralException {
            if (this.compiled && this.fieldVal != null) {
                return this.fieldVal;
            }
            Class<?> cl = Reflection.getRawType(clazz);
            String[] clAndF = this.stringRepresentation.substring(2).split("#");
            if (clAndF.length == 2) {
                String cN = MessMod.INSTANCE.getMapping().srgClass(clAndF[0].replace('/', '.'));
                try {
                    Class<?> decC = Class.forName(MessMod.INSTANCE.getMapping().srgClass(cN));
                    Field f = Reflection.getFieldFromNamed(decC, clAndF[1]);
                    if (f != null) {
                        f.setAccessible(true);
                        this.fieldVal = f.get(null);
                        this.compiled = Modifier.isFinal(f.getModifiers());
                        return this.fieldVal;
                    }
                    throw InvalidLiteralException.createWithArgs(FailureCause.NO_FIELD, this, null, clAndF[1], clAndF[0]);
                }
                catch (ClassNotFoundException e) {
                    throw InvalidLiteralException.createWithArgs(FailureCause.NO_CLASS, this, e, clAndF[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    throw InvalidLiteralException.createWithArgs(FailureCause.ERROR, this, e, e);
                }
            }
            if (clAndF.length == 1) {
                String fieldName = this.stringRepresentation.substring(2);
                if (cl != null) {
                    Field f = Reflection.getFieldFromNamed(cl, fieldName);
                    if (f != null && Modifier.isStatic(f.getModifiers())) {
                        f.setAccessible(true);
                        try {
                            this.fieldVal = f.get(null);
                            this.compiled = Modifier.isFinal(f.getModifiers());
                            return this.fieldVal;
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            e.printStackTrace();
                            throw InvalidLiteralException.createWithArgs(FailureCause.ERROR, this, e, e);
                        }
                    }
                    throw InvalidLiteralException.createWithArgs(FailureCause.NO_FIELD, this, null, clazz == null ? "???" : clazz.getTypeName(), fieldName);
                }
                throw InvalidLiteralException.createWithArgs(FailureCause.UNCERTAIN_CLASS, this, null, fieldName);
            }
            throw InvalidLiteralException.create(FailureCause.INV_STATIC, this);
        }

        @Override
        protected Literal<?> recreate() {
            return new StaticFieldL(this.stringRepresentation);
        }
    }

    public static class ClassL
    extends Literal<Class<?>> {
        private Class<?> classVal;

        protected ClassL(String strRep) {
            super(strRep);
        }

        @Override
        public Class<?> get(Type type) throws InvalidLiteralException {
            if (this.compiled) {
                return this.classVal;
            }
            String className = this.stringRepresentation.substring(2).replace('/', '.');
            String srg = MessMod.INSTANCE.getMapping().srgClass(className);
            try {
                this.classVal = Reflection.getClassIncludingPrimitive(srg);
                this.compiled = true;
                return this.classVal;
            }
            catch (ClassNotFoundException e) {
                throw InvalidLiteralException.createWithArgs(FailureCause.NO_CLASS, this, e, className);
            }
        }
    }

    public static class ArrayL
    extends Literal<Object> {
        private final Supplier<Object> arrayCreator;

        protected ArrayL(String strRep) throws CommandSyntaxException {
            super(strRep);
            Class<?> clazz;
            this.compiled = false;
            int dimListOffset = strRep.indexOf(93);
            if (dimListOffset == -1) {
                throw new TranslatableException("exp.atleast1dim");
            }
            if ((dimListOffset = strRep.substring(0, dimListOffset).lastIndexOf(91)) == -1) {
                throw new TranslatableException("exp.atleast1dim");
            }
            String namedClass = strRep.substring(2, dimListOffset).replace('/', '.');
            String srg = MessMod.INSTANCE.getMapping().srgClass(namedClass);
            try {
                clazz = Reflection.getClassIncludingPrimitive(srg);
            }
            catch (ClassNotFoundException e) {
                throw new TranslatableException("exp.noclass", namedClass);
            }
            IntArrayList dims = new IntArrayList();
            StringReader sr = new StringReader(strRep.substring(dimListOffset));
            while (sr.canRead()) {
                sr.skipWhitespace();
                if (sr.read() != '[' || !sr.canRead()) {
                    throw new TranslatableException("exp.invarray", strRep);
                }
                dims.add(sr.readInt());
                if (sr.canRead() && sr.read() == ']') continue;
                throw new TranslatableException("exp.invarray", strRep);
            }
            int[] dimensions = dims.toIntArray();
            this.arrayCreator = () -> Array.newInstance(clazz, dimensions);
        }

        @Override
        @Nullable
        public Object get(@Nullable Type type) throws InvalidLiteralException {
            return this.arrayCreator.get();
        }
    }

    static class BlockPosL
    extends Literal<class_2338> {
        private class_2338 pos;

        protected BlockPosL(String strRep) {
            super(strRep);
            try {
                String[] comp = strRep.substring(1, strRep.length() - 1).split(",");
                int x = Integer.parseInt(comp[0]);
                int y = Integer.parseInt(comp[1]);
                int z = Integer.parseInt(comp[2]);
                this.pos = new class_2338(x, y, z);
                this.compiled = true;
            }
            catch (Exception e) {
                throw new TranslatableException("exp.invalidbp", strRep);
            }
        }

        @Override
        public class_2338 get(Type clazz) {
            return this.pos;
        }
    }

    public static class Vec3dL
    extends Literal<class_243> {
        private final class_243 vec3d;

        protected Vec3dL(String strRep) {
            super(strRep);
            try {
                String[] comp = strRep.substring(1, strRep.length() - 1).split(",");
                double x = Double.parseDouble(comp[0]);
                double y = Double.parseDouble(comp[1]);
                double z = Double.parseDouble(comp[2]);
                this.vec3d = new class_243(x, y, z);
                this.compiled = true;
            }
            catch (Exception e) {
                throw new TranslatableException("exp.invalidvec3", strRep);
            }
        }

        @Override
        public class_243 get(Type type) {
            return this.vec3d;
        }
    }

    public static class VarL
    extends Literal<Object> {
        private final String slot;

        protected VarL(String strRep) throws CommandSyntaxException {
            super(strRep);
            this.slot = strRep.substring(2);
            this.compiled = false;
        }

        @Override
        @Nullable
        public Object get(@Nullable Type type) throws InvalidLiteralException {
            return VariableCommand.getVariable(this.slot);
        }
    }

    static class NullL
    extends Literal<Void> {
        protected NullL() {
            super("null");
            this.compiled = true;
        }

        @Override
        @Nullable
        public Void get(Type clazz) {
            return null;
        }
    }

    static class DoubleL
    extends Literal<Double> {
        private Double number;

        protected DoubleL(String strRep) {
            super(strRep);
            try {
                this.number = Double.parseDouble(strRep);
                this.compiled = true;
            }
            catch (NumberFormatException e) {
                throw new TranslatableException("exp.reqnum", strRep);
            }
        }

        @Override
        public Double get(Type clazz) {
            return this.number;
        }
    }

    static class FloatL
    extends Literal<Float> {
        private Float number;

        protected FloatL(String strRep) {
            super(strRep);
            try {
                this.number = Float.valueOf(Float.parseFloat(strRep));
                this.compiled = true;
            }
            catch (NumberFormatException e) {
                throw new TranslatableException("exp.reqnum", strRep);
            }
        }

        @Override
        public Float get(Type clazz) {
            return this.number;
        }
    }

    static class LongL
    extends Literal<Long> {
        private Long number;

        protected LongL(String strRep) {
            super(strRep);
            try {
                this.number = Long.parseLong(strRep);
                this.compiled = true;
            }
            catch (NumberFormatException e) {
                throw new TranslatableException("exp.reqint", strRep);
            }
        }

        @Override
        public Long get(Type clazz) {
            return this.number;
        }
    }

    static class IntL
    extends Literal<Integer> {
        private Integer integer;

        protected IntL(String strRep) {
            super(strRep);
            try {
                this.integer = Integer.parseInt(strRep);
                this.compiled = true;
            }
            catch (NumberFormatException e) {
                throw new TranslatableException("exp.reqint", strRep);
            }
        }

        @Override
        public Integer get(Type clazz) {
            return this.integer;
        }
    }
}

