/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.ArgumentListTokenizer;
import lovexyn0827.mess.util.MethodDescriptor;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.BytecodeHelper;
import lovexyn0827.mess.util.access.CompilationContext;
import lovexyn0827.mess.util.access.CompilationException;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.Literal;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.NodeCompiler;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.InsnList;

final class MethodNode
extends Node
implements Cloneable {
    static final Pattern METHOD_PATTERN = Pattern.compile("^(?<name>[$_a-zA-Z0-9]+)(?:\\<(?<types>[^>]*)\\>)?\\((?<args>.*)\\)$");
    private final String name;
    @Nullable
    private final Class<?>[] types;
    private final Literal<?>[] args;
    @Nullable
    private Method method;
    private final Integer argNum;
    @Nullable
    private final Class<?> returnTypes;

    MethodNode(String name, String types, String args) {
        this.name = name;
        if (types != null) {
            if (types.matches("[0-9]+")) {
                this.types = null;
                this.returnTypes = null;
                try {
                    this.argNum = Integer.parseInt(types);
                }
                catch (NumberFormatException e) {
                    throw new TranslatableException("exp.invaildInvocation", this);
                }
            } else {
                this.argNum = null;
                MethodDescriptor desc = MethodDescriptor.parse(MessMod.INSTANCE.getMapping().srgMethodDescriptor(types));
                this.types = desc.argTypes;
                this.returnTypes = desc.returnType;
            }
        } else {
            this.types = null;
            this.argNum = null;
            this.returnTypes = null;
        }
        try {
            this.args = MethodNode.parseArgs(args);
        }
        catch (CommandSyntaxException e) {
            TranslatableException e1 = new TranslatableException("exp.invaildInvocation", this);
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    Object access(Object previous) throws AccessingFailureException {
        this.ensureInitialized();
        try {
            this.method.setAccessible(true);
            Literal<?>[] argsL = this.args;
            Object[] argObjs = new Object[argsL.length];
            Type[] argTypes = this.method.getGenericParameterTypes();
            for (int i = 0; i < argsL.length; ++i) {
                try {
                    argObjs[i] = argsL[i].get(argTypes[i]);
                    continue;
                }
                catch (InvalidLiteralException e) {
                    throw AccessingFailureException.create(e, (Node)this);
                }
            }
            try {
                return this.method.invoke(previous, argObjs);
            }
            catch (IllegalArgumentException e) {
                throw AccessingFailureException.createWithArgs(FailureCause.BAD_ARG, this, e, Arrays.toString(argObjs), this.method.toString());
            }
        }
        catch (InvocationTargetException e) {
            throw AccessingFailureException.createWithArgs(FailureCause.INVOKE_FAIL, this, e.getCause(), this.name, e.getCause());
        }
        catch (AccessingFailureException e) {
            throw e;
        }
        catch (Exception e) {
            if (OptionManager.superSuperSecretSetting) {
                e.printStackTrace();
                MessMod.LOGGER.info("Failed to invoke " + this.method);
            }
            throw AccessingFailureException.createWithArgs(FailureCause.ERROR, this, e, e);
        }
    }

    private void resolveAndSetMethod(Class<? extends Object> clazz) throws AccessingFailureException {
        MutableObject srg = new MutableObject();
        Mapping map = MessMod.INSTANCE.getMapping();
        List candidates = Reflection.listMethods(clazz).stream().filter(arg_0 -> this.lambda$resolveAndSetMethod$0((Mutable)srg, map, clazz, arg_0)).map(Reflection::getDeepestOverridenMethod).distinct().collect(Collectors.toList());
        if (candidates.size() != 1) {
            if (candidates.size() == 0) {
                throw AccessingFailureException.createWithArgs(FailureCause.NO_METHOD, this, null, srg.getValue(), clazz.getSimpleName());
            }
            throw AccessingFailureException.create(FailureCause.MULTI_TARGET, (Node)this);
        }
        this.method = (Method)candidates.get(0);
    }

    public int hashCode() {
        return this.name.hashCode() ^ (this.outputType != null ? this.outputType.hashCode() : 0) ^ Arrays.hashCode(this.args) ^ Arrays.hashCode(this.types);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || MethodNode.class != obj.getClass()) {
            return false;
        }
        MethodNode other = (MethodNode)obj;
        return (this.method != null ? this.method.equals(other.method) : this.name.equals(other.name)) && (this.outputType == null ? other.outputType == null : this.outputType.equals(other.outputType)) && Arrays.equals(this.args, this.args) && Arrays.equals(this.types, this.types);
    }

    public String toString() {
        Object types;
        if (this.argNum != null) {
            types = "<" + this.argNum.toString() + ">";
        } else if (this.types != null) {
            StringBuilder sb = new StringBuilder("<");
            for (Class<?> cl : this.types) {
                sb.append(org.objectweb.asm.Type.getDescriptor((Class)cl));
            }
            sb.append('>');
            types = sb.toString();
        } else {
            types = "";
        }
        StringBuilder sb2 = new StringBuilder("(");
        if (this.args != null) {
            for (Literal<?> l : this.args) {
                sb2.append(l.stringRepresentation);
                sb2.append(',');
            }
        } else {
            sb2.append("???");
        }
        sb2.append(')');
        return this.name + (String)types + sb2;
    }

    @Override
    boolean canFollow(Node n) {
        return n.outputType != null && Reflection.listMethods(Reflection.getRawType(n.outputType)).contains(this.method);
    }

    @Override
    void initialize(Type lastOutType) throws AccessingFailureException {
        Class<?> cl = Reflection.getRawType(lastOutType);
        this.resolveAndSetMethod(cl);
        super.initialize(lastOutType);
    }

    @Override
    protected Type resolveOutputType(Type lastOutType) {
        return Reflection.resolveMemberType(this.method.getGenericReturnType(), lastOutType);
    }

    public static Literal<?>[] parseArgs(String argsStr) throws CommandSyntaxException {
        if (argsStr.isEmpty()) {
            return new Literal[0];
        }
        String[] args = new ArgumentListTokenizer(argsStr).toArray();
        Literal[] result = new Literal[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isEmpty()) {
                throw new TranslatableException("exp.emptyarg");
            }
            result[i] = Literal.parse(args[i]);
        }
        return result;
    }

    @Override
    void uninitialize() {
        super.uninitialize();
        this.method = null;
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = this.args[i].recreate();
            }
        }
    }

    @Override
    Node createCopyForInput(Object input) {
        try {
            MethodNode mn = (MethodNode)this.clone();
            mn.uninitialize();
            mn.ordinary = this.ordinary;
            return mn;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    NodeCompiler getCompiler() {
        return ctx -> {
            InsnList insns = new InsnList();
            if (this.method == null) {
                throw new CompilationException(FailureCause.ERROR, new Object[0]);
            }
            int argsLength = this.args.length;
            Class<?>[] argTypes = this.method.getParameterTypes();
            for (int i = 0; i < argsLength; ++i) {
                Literal<?> literal = this.args[i];
                BytecodeHelper.appendConstantLoader(ctx, insns, literal, argTypes[i]);
            }
            BytecodeHelper.appendCaller(insns, this.method, CompilationContext.CallableType.INVOKER);
            ctx.endNode(this.method.getGenericReturnType());
            return insns;
        };
    }

    private /* synthetic */ boolean lambda$resolveAndSetMethod$0(Mutable srg, Mapping map, Class clazz, Method m) {
        String descriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)m);
        srg.setValue((Object)map.srgMethodRecursively(clazz, this.name, descriptor));
        if (m.getName().equals(srg.getValue())) {
            if (this.argNum != null) {
                return this.argNum.equals(m.getParameterCount());
            }
            if (this.types != null) {
                return Arrays.equals(this.types, m.getParameterTypes());
            }
            return true;
        }
        return false;
    }
}

