/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.access.AccessingPathArgumentType;
import lovexyn0827.mess.util.access.BytecodeHelper;
import lovexyn0827.mess.util.access.CompilationContext;
import lovexyn0827.mess.util.access.CompilationException;
import lovexyn0827.mess.util.access.CompiledPath;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.Literal;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.PathClassLoader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.TraceClassVisitor;

class PathCompiler {
    private final LinkedList<Node> nodes = new LinkedList();
    private final CompilationContext ctx;
    private ClassNode classFile;
    private String className;
    private InsnList clinitInsns;

    public PathCompiler(List<Node> compilers, List<Class<?>> nodeInputTypes, String name) {
        compilers.forEach(this.nodes::add);
        this.ctx = new CompilationContext(nodeInputTypes, name);
        this.className = this.ctx.getInternalClassNameOfPath();
    }

    public Class<?> compile() throws CompilationException {
        ClassWriter cw = new ClassWriter(3);
        Object wrappedCw = OptionManager.superSuperSecretSetting ? new TraceClassVisitor((ClassVisitor)cw, new PrintWriter(System.out)) : cw;
        this.classFile = new ClassNode();
        this.classFile.visit(52, 4097, this.className, null, Type.getInternalName(CompiledPath.class), new String[0]);
        MethodNode initMethod = new MethodNode(4097, "<init>", "()V", null, new String[0]);
        InsnList initInsns = initMethod.instructions;
        initInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        initInsns.add((AbstractInsnNode)new LdcInsnNode((Object)this.ctx.getOriginalName()));
        initInsns.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(CompiledPath.class), "<init>", "(Ljava/lang/String;)V"));
        initInsns.add((AbstractInsnNode)new InsnNode(177));
        this.classFile.methods.add(initMethod);
        this.buildAccessMethod();
        MethodNode clinit = new MethodNode(4105, "<clinit>", "()V", null, new String[0]);
        this.classFile.methods.add(clinit);
        this.clinitInsns = clinit.instructions;
        this.prepareStaticConstants();
        this.prepareLambdas();
        this.prepareSubPaths();
        this.prepareDynamicLiterals();
        this.clinitInsns.add((AbstractInsnNode)new InsnNode(177));
        HashMap fieldsByName = new HashMap();
        this.classFile.fields.forEach(fn -> fieldsByName.put(fn.name, fn));
        for (MethodNode mn : this.classFile.methods) {
            for (AbstractInsnNode insn : mn.instructions) {
                if (!(insn instanceof FieldInsnNode)) continue;
                FieldInsnNode finsn = (FieldInsnNode)insn;
                if (finsn.desc != BytecodeHelper.UNCERTAIN_FIELD_DESCRIPTOR || finsn.owner != this.className) continue;
                finsn.desc = ((FieldNode)fieldsByName.get((Object)finsn.name)).desc;
            }
        }
        MethodNode getOutputType = new MethodNode(4097, "getOutputType", "()Ljava/lang/reflect/Type;", null, new String[0]);
        InsnList gOTInsns = getOutputType.instructions;
        gOTInsns.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType(Reflection.wrapPrimitiveType(this.ctx.getLastOutputClass()))));
        gOTInsns.add((AbstractInsnNode)new InsnNode(176));
        this.classFile.methods.add(getOutputType);
        this.classFile.accept((ClassVisitor)wrappedCw);
        byte[] clBytes = cw.toByteArray();
        if (OptionManager.superSuperSecretSetting) {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(this.className.replace('/', '.') + ".class")));){
                bos.write(clBytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return PathClassLoader.INSTANCE.defineClass(this.className.replace('/', '.'), clBytes);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private void prepareDynamicLiterals() {
        List<Literal<?>> literals = this.ctx.getDynamicLiterals();
        int count = literals.size();
        String desc = "[" + Type.getDescriptor(Literal.class);
        FieldNode fn = new FieldNode(4122, "DYNAMIC_LITERALS", desc, null, null);
        this.classFile.fields.add(fn);
        InsnList insns = this.clinitInsns;
        insns.add((AbstractInsnNode)new IntInsnNode(16, count));
        insns.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Literal.class)));
        insns.add((AbstractInsnNode)new FieldInsnNode(179, this.className, "DYNAMIC_LITERALS", desc));
        for (int i = 0; i < count; ++i) {
            insns.add((AbstractInsnNode)new FieldInsnNode(178, this.className, "DYNAMIC_LITERALS", desc));
            insns.add((AbstractInsnNode)new IntInsnNode(16, i));
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)literals.get(i).serialize()));
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Literal.class), "parse", "(Ljava/lang/String;)Llovexyn0827/mess/util/access/Literal;"));
            insns.add((AbstractInsnNode)new InsnNode(83));
        }
    }

    private void prepareSubPaths() {
        List<AccessingPath> paths = this.ctx.getSubPaths();
        int count = paths.size();
        String desc = "[" + Type.getDescriptor(AccessingPath.class);
        FieldNode fn = new FieldNode(4122, "SUBPATHS", desc, null, null);
        this.classFile.fields.add(fn);
        InsnList insns = this.clinitInsns;
        insns.add((AbstractInsnNode)new IntInsnNode(16, count));
        insns.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(AccessingPath.class)));
        insns.add((AbstractInsnNode)new FieldInsnNode(179, this.className, "SUBPATHS", desc));
        for (int i = 0; i < count; ++i) {
            insns.add((AbstractInsnNode)new FieldInsnNode(178, this.className, "SUBPATHS", desc));
            insns.add((AbstractInsnNode)new IntInsnNode(16, i));
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(AccessingPathArgumentType.class), "accessingPathArg", "()" + Type.getDescriptor(AccessingPathArgumentType.class)));
            insns.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(StringReader.class)));
            insns.add((AbstractInsnNode)new InsnNode(89));
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)paths.get(i).getOriginalStringRepresentation()));
            insns.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(StringReader.class), "<init>", "(Ljava/lang/String;)V"));
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(AccessingPathArgumentType.class), "parse", Type.getMethodDescriptor((Type)Type.getType(AccessingPath.class), (Type[])new Type[]{Type.getType(StringReader.class)})));
            insns.add((AbstractInsnNode)new InsnNode(83));
        }
    }

    private void prepareLambdas() throws CompilationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeInt(this.ctx.getLambdas().size());
            for (Function<?, ?> func : this.ctx.getLambdas()) {
                oos.writeObject(func);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CompilationException(FailureCause.ERROR, e.getLocalizedMessage());
        }
        byte[] bytes = baos.toByteArray();
        AnnotationNode an = new AnnotationNode(Type.getDescriptor(CompiledPath.Lambdas.class));
        an.values = Lists.newArrayList((Object[])new Object[]{"bytes", bytes});
        this.classFile.visibleAnnotations = Lists.newArrayList((Object[])new AnnotationNode[]{an});
        FieldNode fn = new FieldNode(4122, "LAMBDAS", "[Ljava/util/function/Function;", null, null);
        this.classFile.fields.add(fn);
        this.clinitInsns.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)("L" + this.className + ";"))));
        this.clinitInsns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(CompiledPath.class), "parseLambdas", "(Ljava/lang/Class;)[Ljava/util/function/Function;"));
        this.clinitInsns.add((AbstractInsnNode)new FieldInsnNode(179, this.className, "LAMBDAS", "[Ljava/util/function/Function;"));
    }

    private void prepareStaticConstants() throws CompilationException {
        InsnList arrayCreation = new InsnList();
        InsnList cstLoading = new InsnList();
        this.ctx.getStaticLiterals().forEach((cl, listWrapper) -> {
            String fieldName = "SC$" + listWrapper.getFirst();
            List list = (List)listWrapper.getSecond();
            int cstCountInType = list.size();
            String fieldType = "[" + Type.getDescriptor((Class)cl);
            FieldNode fn = new FieldNode(4122, fieldName, fieldType, null, null);
            this.classFile.fields.add(fn);
            arrayCreation.add((AbstractInsnNode)new IntInsnNode(16, cstCountInType));
            arrayCreation.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName((Class)cl)));
            arrayCreation.add((AbstractInsnNode)new FieldInsnNode(179, this.className, fieldName, fieldType));
            for (int i = 0; i < cstCountInType; ++i) {
                cstLoading.add((AbstractInsnNode)new FieldInsnNode(178, this.className, fieldName, fieldType));
                cstLoading.add((AbstractInsnNode)new IntInsnNode(16, i));
                cstLoading.add((AbstractInsnNode)new LdcInsnNode((Object)((Literal)list.get((int)i)).stringRepresentation));
                cstLoading.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Literal.class), "parse", "(Ljava/lang/String;)Llovexyn0827/mess/util/access/Literal;"));
                cstLoading.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((Class)cl)));
                cstLoading.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Literal.class), "get", "(Ljava/lang/reflect/Type;)Ljava/lang/Object;"));
                cstLoading.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName((Class)cl)));
                cstLoading.add((AbstractInsnNode)new InsnNode(83));
            }
        });
        this.clinitInsns.add(arrayCreation);
        this.clinitInsns.add(cstLoading);
    }

    private void buildAccessMethod() throws CompilationException {
        MethodNode accessMethod = new MethodNode(4097, "access", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Ljava/lang/Object;", null, new String[]{Type.getInternalName(AccessingFailureException.class)});
        int i = 0;
        InsnList accessInsns = accessMethod.instructions;
        accessInsns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        accessInsns.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(this.ctx.getInputClassOverrideAt(0))));
        for (Node node : this.nodes) {
            Class<?> lastOutputCl = this.ctx.getLastOutputClass();
            if (lastOutputCl.isPrimitive() && !node.allowsPrimitiveTypes()) {
                BytecodeHelper.appendPrimitiveWrapper(accessInsns, lastOutputCl);
            }
            try {
                node.initialize(this.ctx.getLastOutputType());
            }
            catch (AccessingFailureException e) {
                e.printStackTrace();
                throw new CompilationException(e.failureCause, e.args);
            }
            InsnList insns = node.getCompiler().compile(this.ctx);
            LabelNode l = new LabelNode();
            accessInsns.add((AbstractInsnNode)l);
            accessInsns.add((AbstractInsnNode)new LineNumberNode(i++, l));
            accessInsns.add(insns);
        }
        Class<?> finalType = this.ctx.getLastOutputClass();
        if (finalType == Void.TYPE) {
            accessInsns.add((AbstractInsnNode)new InsnNode(1));
        } else if (finalType.isPrimitive()) {
            BytecodeHelper.appendPrimitiveWrapper(accessInsns, finalType);
        }
        accessInsns.add((AbstractInsnNode)new InsnNode(176));
        this.classFile.methods.add(accessMethod);
        this.ctx.lockConstantLists();
    }
}

