/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.blame;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.blame.Cause;
import lovexyn0827.mess.util.blame.TraceElement;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3611;

public class AnalyzedCause
implements Cause {
    private final ImmutableSet<Clue> clues;

    AnalyzedCause(Set<Clue> clues) {
        ArrayList<Clue> l = new ArrayList<Clue>(clues);
        Collections.sort(l, (c1, c2) -> c1.category().compareTo(c2.category()));
        this.clues = ImmutableSet.copyOf(l);
    }

    public ImmutableSet<Clue> getClues() {
        return this.clues;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Clue c : this.clues) {
            sb.append(c.name()).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.clues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedCause other = (AnalyzedCause)obj;
        return Objects.equals(this.clues, other.clues);
    }

    public static interface Clue {
        public static final ImmutableMap<Class<?>, Set<class_3545<Predicate<TraceElement>, Clue>>> BUILTIN = (ImmutableMap)class_156.method_656(() -> {
            HashMap temp = new HashMap();
            Reflection.ENTITY_TYPE_TO_CLASS.forEach((type, cl) -> {
                Set clues = temp.computeIfAbsent((Class<?>)cl, k -> new HashSet());
                clues.add(new class_3545(te -> true, (Object)new TypeC(class_1299.method_5890((class_1299)type).method_12832(), Category.ENTITY)));
            });
            Reflection.BLOCK_ENTITY_TYPE_TO_CLASS.forEach((type, cl) -> {
                Set clues = temp.computeIfAbsent((Class<?>)cl, k -> new HashSet());
                clues.add(new class_3545(te -> true, (Object)new TypeC(class_2591.method_11033((class_2591)type).method_12832(), Category.BLOCK_ENTITY)));
            });
            EntityC.register(temp);
            BlockEntityC.register(temp);
            ChunkManagerC.register(temp);
            WorldC.register(temp);
            ServerWorldC.register(temp);
            return ImmutableMap.copyOf(temp);
        });

        public String name();

        public Category category();

        public static enum Category {
            ENTITY,
            BLOCK_ENTITY,
            CHUNK_MANAGER,
            WORLD,
            SERVER_WORLD,
            GENERATION,
            UNSPECIFIED;

        }
    }

    private static enum ServerWorldC implements Clue
    {
        TICK(Reflection.getMethodForInternalPropose(class_3218.class, "tick", "method_18765", BooleanSupplier.class)),
        TICK_NTE_BLOCK(Reflection.getMethodForInternalPropose(class_3218.class, "tickBlock", "method_14189", class_2338.class, class_2248.class)),
        TICK_NTE_FLUID(Reflection.getMethodForInternalPropose(class_3218.class, "tickFluid", "method_14171", class_2338.class, class_3611.class)),
        BLOCK_EVENT(Reflection.getMethodForInternalPropose(class_3218.class, "processBlockEvent", "method_14174", class_1919.class)),
        TICK_CHUNK(Reflection.getMethodForInternalPropose(class_3218.class, "tickChunk", "method_18203", class_2818.class, Integer.TYPE));

        private final Method sign;

        private ServerWorldC(Method sign) {
            this.sign = sign;
        }

        static void register(Map<Class<?>, Set<class_3545<Predicate<TraceElement>, Clue>>> temp) {
            Set clues = temp.computeIfAbsent(class_3218.class, k -> new HashSet());
            for (ServerWorldC c : ServerWorldC.values()) {
                clues.add(new class_3545(te -> te.mentionsConsideringInherance(c.sign).isAtLeast(OptionManager.blameThreshold), (Object)c));
            }
        }

        @Override
        public Clue.Category category() {
            return Clue.Category.SERVER_WORLD;
        }
    }

    private static enum WorldC implements Clue
    {
        GET_ENTITY(Reflection.getMethodForInternalPropose(class_1937.class, "getEntitiesIncludingUngeneratedChunks", "method_21728", Class.class, class_238.class, Predicate.class)),
        GET_BLOCK(Reflection.getMethodForInternalPropose(class_1937.class, "getBlockState", "method_8320", class_2338.class));

        private final Method sign;

        private WorldC(Method sign) {
            this.sign = sign;
        }

        static void register(Map<Class<?>, Set<class_3545<Predicate<TraceElement>, Clue>>> temp) {
            Set clues = temp.computeIfAbsent(class_1937.class, k -> new HashSet());
            for (WorldC c : WorldC.values()) {
                clues.add(new class_3545(te -> te.mentionsConsideringInherance(c.sign).isAtLeast(OptionManager.blameThreshold), (Object)c));
            }
        }

        @Override
        public Clue.Category category() {
            return Clue.Category.WORLD;
        }
    }

    private static enum ChunkManagerC implements Clue
    {
        TICK(Reflection.getMethodForInternalPropose(class_3215.class, "tick", "method_12127", BooleanSupplier.class)),
        UPDATE(Reflection.getMethodForInternalPropose(class_3215.class, "tick", "method_16155", new Class[0])),
        GET_CHUNK(Reflection.getMethodForInternalPropose(class_3215.class, "getChunk", "method_12121", Integer.TYPE, Integer.TYPE, class_2806.class, Boolean.TYPE)),
        GET_WORLD_CHUNK(Reflection.getMethodForInternalPropose(class_3215.class, "getWorldChunk", "method_21730", Integer.TYPE, Integer.TYPE));

        private final Method sign;

        private ChunkManagerC(Method sign) {
            this.sign = sign;
        }

        static void register(Map<Class<?>, Set<class_3545<Predicate<TraceElement>, Clue>>> temp) {
            Set clues = temp.computeIfAbsent(class_3215.class, k -> new HashSet());
            for (ChunkManagerC c : ChunkManagerC.values()) {
                clues.add(new class_3545(te -> te.mentionsConsideringInherance(c.sign).isAtLeast(OptionManager.blameThreshold), (Object)c));
            }
        }

        @Override
        public Clue.Category category() {
            return Clue.Category.CHUNK_MANAGER;
        }
    }

    private static enum BlockEntityC implements Clue
    {
        TICK_BE;

        private static final Set<String> TICK_METHOD_NAMES;

        static void register(Map<Class<?>, Set<class_3545<Predicate<TraceElement>, Clue>>> temp) {
            Reflection.BLOCK_ENTITY_TYPE_TO_CLASS.values().forEach(cl -> {
                Set clues = temp.computeIfAbsent((Class<?>)cl, k -> new HashSet());
                for (BlockEntityC bec : BlockEntityC.values()) {
                    clues.add(new class_3545(te -> TICK_METHOD_NAMES.contains(te.methodName), (Object)bec));
                }
            });
        }

        @Override
        public Clue.Category category() {
            return Clue.Category.BLOCK_ENTITY;
        }

        static {
            TICK_METHOD_NAMES = ImmutableSet.of((Object)"method_16896", (Object)"tick");
        }
    }

    private static enum EntityC implements Clue
    {
        TICK_ENTITY(Reflection.getMethodForInternalPropose(class_1297.class, "tick", "method_5773", new Class[0])),
        MOVE(Reflection.getMethodForInternalPropose(class_1297.class, "move", "method_5784", class_1313.class, class_243.class)),
        COLLISION_DETECTION(Reflection.getMethodForInternalPropose(class_1297.class, "adjustMovementForCollisions", "method_17835", class_243.class)),
        BLOCK_COLLISION(Reflection.getMethodForInternalPropose(class_1297.class, "checkBlockCollision", "method_5852", new Class[0]));

        private final Method sign;

        private EntityC(Method sign) {
            this.sign = sign;
        }

        static void register(Map<Class<?>, Set<class_3545<Predicate<TraceElement>, Clue>>> temp) {
            Reflection.ENTITY_TYPE_TO_CLASS.values().forEach(cl -> {
                Set clues = temp.computeIfAbsent((Class<?>)cl, k -> new HashSet());
                for (EntityC ec : EntityC.values()) {
                    clues.add(new class_3545(te -> te.mentionsConsideringInherance(ec.sign).isAtLeast(OptionManager.blameThreshold), (Object)ec));
                }
            });
        }

        @Override
        public Clue.Category category() {
            return Clue.Category.ENTITY;
        }
    }

    private static final class TypeC
    implements Clue {
        private final String type;
        private final Clue.Category category;

        TypeC(String type, Clue.Category category) {
            this.type = type;
            this.category = category;
        }

        @Override
        public String name() {
            return this.type;
        }

        @Override
        public Clue.Category category() {
            return this.category;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.category, this.type});
        }

        public String toString() {
            return this.category + ": " + this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeC other = (TypeC)obj;
            return this.category == other.category && Objects.equals(this.type, other.type);
        }
    }
}

