/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.blame;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.blame.AnalyzedCause;
import lovexyn0827.mess.util.blame.Confidence;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import net.minecraft.class_3545;

public final class TraceElement {
    public final Class<?> clazz;
    public final String className;
    public final String methodName;
    public final int lineNum;
    public final Set<Executable> suspectedMethods;
    private final boolean isNotMc;

    private TraceElement(Class<?> clazz, String className, String methodName, int lineNum, Set<Executable> suspectedMethods) {
        this.clazz = clazz;
        this.className = className;
        this.methodName = methodName;
        this.lineNum = lineNum;
        this.suspectedMethods = suspectedMethods;
        this.isNotMc = !this.clazz.getName().startsWith("net.minecraft");
    }

    public static TraceElement from(StackTraceElement e) {
        HashSet<Executable> susM;
        String mName;
        Class<?> cl;
        block5: {
            block4: {
                try {
                    cl = Class.forName(e.getClassName());
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                    throw new IllegalArgumentException(e1);
                }
                mName = e.getMethodName();
                susM = new HashSet<Executable>();
                if (!"<init>".equals(mName)) break block4;
                for (Constructor<?> c : cl.getDeclaredConstructors()) {
                    susM.add(c);
                }
                break block5;
            }
            if ("<clinit>".equals(mName)) break block5;
            for (Method m : cl.getDeclaredMethods()) {
                if (!mName.equals(m.getName())) continue;
                susM.add(m);
            }
        }
        return new TraceElement(cl, e.getClassName(), mName, e.getLineNumber(), susM);
    }

    public Set<AnalyzedCause.Clue> blame() {
        if (this.isNotMc) {
            return Collections.emptySet();
        }
        Set set = (Set)AnalyzedCause.Clue.BUILTIN.get(this.clazz);
        if (set == null) {
            return Collections.emptySet();
        }
        return set.stream().filter(p -> ((Predicate)p.method_15442()).test(this)).map(class_3545::method_15441).collect(Collectors.toSet());
    }

    public Confidence mentions(Executable m) {
        if (this.suspectedMethods.contains(m)) {
            return this.suspectedMethods.size() == 1 ? Confidence.DEFINITE : Confidence.POSSIBLE;
        }
        return Confidence.IMPOSSIBLE;
    }

    public Confidence mentionsConsideringInherance(Executable m) {
        if (this.suspectedMethods.stream().anyMatch(sm -> Reflection.isOverriding(sm, m))) {
            return this.suspectedMethods.size() == 1 ? Confidence.DEFINITE : Confidence.POSSIBLE;
        }
        return Confidence.IMPOSSIBLE;
    }

    public Confidence withinLineRange(int minLine, int maxLine) {
        if (minLine < 0 || maxLine < 0 || minLine > maxLine) {
            throw new IllegalArgumentException(String.format("Invalid range: [%d, %d]", minLine, maxLine));
        }
        if (this.lineNum < 0) {
            return Confidence.UNLIKELY;
        }
        return this.lineNum <= maxLine && this.lineNum >= minLine ? Confidence.DEFINITE : Confidence.IMPOSSIBLE;
    }

    public TraceElement mapToNamed() {
        Mapping map = MessMod.INSTANCE.getMapping();
        return new TraceElement(this.clazz, map.namedClass(this.className), map.namedMethod(this.methodName, null), this.lineNum, this.suspectedMethods);
    }
}

