/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.i18n;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.OptionParser;
import lovexyn0827.mess.util.i18n.I18N;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class Language {
    public static final String FORCELOAD_SUFFIX = "_FORCELOAD";
    private final String readableName;
    private final Map<String, String> translations = Maps.newHashMap();
    private final String id;

    public Language(String id) throws Exception {
        this.id = id;
        Path langFile = ((ModContainer)FabricLoader.getInstance().getModContainer("messmod").get()).getRootPath().resolve("assets/lang/" + id + ".json");
        try {
            JsonObject def = new JsonParser().parse(new String(Files.readAllBytes(langFile), Charset.forName("GBK"))).getAsJsonObject();
            this.readableName = def.get("readableName").getAsString();
            def.getAsJsonObject("translations").entrySet().forEach(e -> this.translations.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString()));
        }
        catch (Exception e2) {
            MessMod.LOGGER.error("Failed to load the definition of language " + id);
            e2.printStackTrace();
            throw e2;
        }
    }

    public String translate(String key) {
        if (!this.translations.containsKey(key)) {
            return key;
        }
        return this.translations.get(key);
    }

    public String getName() {
        return this.readableName;
    }

    public boolean vaildate() {
        Set<String> en;
        if ("en_us".equals(this.id)) {
            return true;
        }
        Set<String> here = this.translations.keySet();
        if (here.containsAll(en = I18N.EN_US.translations.keySet()) && en.containsAll(here)) {
            return true;
        }
        en.stream().filter(key -> !here.contains(key)).forEach(key -> MessMod.LOGGER.warn("Absence: " + key));
        here.stream().filter(key -> !en.contains(key)).forEach(key -> MessMod.LOGGER.warn("Redunancy: " + key));
        return false;
    }

    public boolean containsKey(String mayKey) {
        return this.translations.containsKey(mayKey);
    }

    public static class Parser
    implements OptionParser<String> {
        @Override
        public String tryParse(String str) throws InvalidOptionException {
            if ("-FOLLOW_SYSTEM_SETTINGS-".equals(str) || I18N.SUPPORTED_LANGUAGES.contains((Object)str.replace(Language.FORCELOAD_SUFFIX, ""))) {
                return str;
            }
            throw new InvalidOptionException("opt.err.nodef", str);
        }

        @Override
        public String serialize(String val) {
            return val;
        }

        @Override
        public Set<String> createSuggestions() {
            HashSet<String> langs = new HashSet<String>();
            langs.add("-FOLLOW_SYSTEM_SETTINGS-");
            I18N.SUPPORTED_LANGUAGES.forEach(l -> {
                langs.add((String)l);
                langs.add(l + Language.FORCELOAD_SUFFIX);
            });
            return langs;
        }
    }
}

