/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess;

import java.io.IOException;
import java.util.UUID;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.command.LagCommand;
import lovexyn0827.mess.command.LogMovementCommand;
import lovexyn0827.mess.electronic.Oscilscope;
import lovexyn0827.mess.electronic.WaveGenerator;
import lovexyn0827.mess.log.chunk.ChunkBehaviorLogger;
import lovexyn0827.mess.log.entity.EntityLogger;
import lovexyn0827.mess.mixins.WorldSavePathMixin;
import lovexyn0827.mess.network.MessClientNetworkHandler;
import lovexyn0827.mess.network.MessServerNetworkHandler;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.rendering.BlockInfoRenderer;
import lovexyn0827.mess.rendering.ChunkLoadingInfoRenderer;
import lovexyn0827.mess.rendering.FlowerFieldRenderer;
import lovexyn0827.mess.rendering.ServerSyncedBoxRenderer;
import lovexyn0827.mess.rendering.ShapeCache;
import lovexyn0827.mess.rendering.ShapeRenderer;
import lovexyn0827.mess.rendering.ShapeSender;
import lovexyn0827.mess.rendering.hud.ClientHudManager;
import lovexyn0827.mess.rendering.hud.PlayerHud;
import lovexyn0827.mess.rendering.hud.ServerHudManager;
import lovexyn0827.mess.util.access.CustomNode;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import lovexyn0827.mess.util.deobfuscating.MappingProvider;
import lovexyn0827.mess.util.phase.ClientTickingPhase;
import lovexyn0827.mess.util.phase.ServerTickingPhase;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2598;
import net.minecraft.class_2661;
import net.minecraft.class_2678;
import net.minecraft.class_2724;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class MessMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final MessMod INSTANCE = new MessMod();
    private Mapping mapping;
    @Environment(value=EnvType.CLIENT)
    private ClientHudManager hudManagerC;
    private ServerHudManager hudManagerS;
    private ServerSyncedBoxRenderer boxRenderer;
    @Nullable
    private MinecraftServer server;
    private String scriptDir;
    @Environment(value=EnvType.CLIENT)
    public ShapeRenderer shapeRenderer;
    @Environment(value=EnvType.CLIENT)
    public ShapeCache shapeCache;
    public ShapeSender shapeSender;
    private BlockInfoRenderer blockInfoRederer = new BlockInfoRenderer();
    private EntityLogger entityLogger;
    @Environment(value=EnvType.CLIENT)
    private MessClientNetworkHandler clientNetworkHandler;
    private MessServerNetworkHandler serverNetworkHandler;
    private ChunkLoadingInfoRenderer chunkLoadingInfoRenderer;
    private ChunkBehaviorLogger chunkLogger;
    private FlowerFieldRenderer flowerFieldRenderer;
    private Oscilscope oscilscope;
    private WaveGenerator waveGenerator;
    private volatile long gameTime;

    private MessMod() {
        this.reloadMapping();
    }

    public void reloadMapping() {
        this.mapping = new MappingProvider().tryLoadMapping();
    }

    public void onInitialize() {
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void onServerTicked(MinecraftServer server) {
        if (this.hudManagerS != null) {
            this.hudManagerS.tick(server);
        }
        this.boxRenderer.tick();
        this.blockInfoRederer.tick();
        this.flowerFieldRenderer.tick();
        this.shapeSender.updateClientTime(server.method_30002().method_8510());
        this.entityLogger.serverTick();
        LogMovementCommand.tick(server);
        LagCommand.tick();
    }

    public void onServerStarted(MinecraftServer server) {
        this.server = server;
        CommandUtil.updateServer(server);
        OptionManager.updateServer(server);
        this.serverNetworkHandler = new MessServerNetworkHandler(server);
        this.boxRenderer = new ServerSyncedBoxRenderer(server);
        this.blockInfoRederer.initializate(server);
        this.flowerFieldRenderer = new FlowerFieldRenderer(server);
        this.hudManagerS = new ServerHudManager(server);
        CustomNode.reload(server);
        this.chunkLoadingInfoRenderer = new ChunkLoadingInfoRenderer();
        this.entityLogger = new EntityLogger(server);
        this.shapeSender = ShapeSender.create(server);
        this.chunkLogger = new ChunkBehaviorLogger(server);
        this.oscilscope = new Oscilscope();
        this.waveGenerator = new WaveGenerator();
    }

    public void onServerShutdown(MinecraftServer server) {
        this.boxRenderer = null;
        this.server = null;
        this.entityLogger.closeAll();
        this.hudManagerS = null;
        this.entityLogger.closeAll();
        this.serverNetworkHandler = null;
        this.chunkLoadingInfoRenderer.close();
        this.chunkLoadingInfoRenderer = null;
        this.flowerFieldRenderer = null;
        this.oscilscope = null;
        this.waveGenerator = null;
        ServerTickingPhase.initialize();
        if (OptionManager.entityLogAutoArchiving) {
            try {
                this.entityLogger.archiveLogs();
            }
            catch (IOException e) {
                LOGGER.error("Failed to archive entity logs!");
                e.printStackTrace();
            }
        }
        if (OptionManager.chunkLogAutoArchiving) {
            try {
                this.chunkLogger.archiveLogs();
            }
            catch (IOException e) {
                LOGGER.error("Failed to archive entity logs!");
                e.printStackTrace();
            }
        }
        this.entityLogger = null;
        this.chunkLogger = null;
        CommandUtil.updateServer(null);
        OptionManager.updateServer(null);
    }

    public void onServerPlayerSpawned(class_3222 player) {
        if (MessMod.isDedicatedServerEnv()) {
            OptionManager.sendOptionsTo(player);
        }
        CommandUtil.tryUpdatePlayer(player);
        this.scriptDir = this.server.method_27050(WorldSavePathMixin.create("scripts")).toAbsolutePath().toString();
        this.oscilscope.sendAllChannelsTo(player);
    }

    @Environment(value=EnvType.CLIENT)
    public void onRender(class_746 player, class_1132 server) {
        if (this.getClientHudManager() != null) {
            this.getClientHudManager().render(player, server);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void onGameJoined(class_2678 packet) {
        ShapeRenderer sr;
        class_310 mc = class_310.method_1551();
        this.clientNetworkHandler = new MessClientNetworkHandler(mc);
        this.clientNetworkHandler.sendVersion();
        class_746 player = mc.field_1724;
        this.shapeRenderer = sr = new ShapeRenderer(mc);
        this.shapeCache = sr.getShapeCache();
        this.hudManagerC = new ClientHudManager();
        this.hudManagerC.playerHudS = new PlayerHud(this.hudManagerC, (class_1657)player, true);
        if (MessMod.isDedicatedEnv()) {
            this.oscilscope = new Oscilscope();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void onClientTickStart() {
        ClientTickingPhase.CLIENT_TICK_START.begin(null);
    }

    @Environment(value=EnvType.CLIENT)
    public void onClientTicked() {
        ClientTickingPhase.CLIENT_TICK_END.begin(null);
        ServerHudManager shm = this.getServerHudManager();
        if (this.entityLogger != null) {
            this.entityLogger.clientTick();
        }
        if (shm != null && shm.playerHudC != null) {
            class_746 player = class_310.method_1551().field_1724;
            shm.playerHudC.updateData((class_1297)player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void onDisconnected() {
        this.hudManagerC = null;
    }

    @Environment(value=EnvType.CLIENT)
    public void onPlayerRespawned(class_2724 packet) {
    }

    public void sendMessageToEveryone(Object ... message) {
        if (this.server == null) {
            throw new IllegalStateException("Called without a server started!");
        }
        StringBuilder sb = new StringBuilder();
        for (Object ob : message) {
            sb.append(ob);
        }
        this.server.method_3760().method_14616((class_2561)new class_2585(sb.toString()), class_2556.field_11735, new UUID(3273611L, 3272888L));
    }

    public String getScriptDir() {
        return this.scriptDir;
    }

    public EntityLogger getEntityLogger() {
        return this.entityLogger;
    }

    @Environment(value=EnvType.CLIENT)
    public ClientHudManager getClientHudManager() {
        return this.hudManagerC;
    }

    public ServerHudManager getServerHudManager() {
        return this.hudManagerS;
    }

    public static boolean isDedicatedEnv() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return true;
        }
        class_310 mc = class_310.method_1551();
        return mc.method_1576() == null;
    }

    @Environment(value=EnvType.CLIENT)
    public void onDisconnect(class_2661 packet) {
        this.shapeCache.reset();
        this.clientNetworkHandler = null;
    }

    public MessServerNetworkHandler getServerNetworkHandler() {
        return this.serverNetworkHandler;
    }

    @Environment(value=EnvType.CLIENT)
    public MessClientNetworkHandler getClientNetworkHandler() {
        return this.clientNetworkHandler;
    }

    public static boolean isDedicatedServerEnv() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public boolean isOnThread(class_2598 side) {
        if (side == class_2598.field_11942) {
            return class_310.method_1551().method_18854();
        }
        return this.server != null ? this.server.method_18854() : false;
    }

    public ChunkBehaviorLogger getChunkLogger() {
        return this.chunkLogger;
    }

    public long getGameTime() {
        return this.gameTime;
    }

    public void updateTime(long time) {
        this.gameTime = time;
    }

    public Oscilscope getOscilscope() {
        return this.oscilscope;
    }

    public WaveGenerator getWaveGenerator() {
        return this.waveGenerator;
    }
}

