/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Supplier;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.access.AccessingPathArgumentType;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.Literal;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

public class EntityFieldCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        SuggestionProvider suggests = (ct, builder) -> {
            for (String fieldName : Reflection.getAvailableFieldNames(class_2186.method_9313((CommandContext)ct.getLastChild(), (String)"target").getClass())) {
                builder = builder.suggest(fieldName);
            }
            builder.suggest("-THIS-");
            return builder.buildFuture();
        };
        Supplier<AccessingPathArgumentType> pathArgSupplier = () -> AccessingPathArgumentType.accessingPathArg(ct -> {
            class_1297 entity;
            try {
                entity = class_2186.method_9313((CommandContext)ct, (String)"target");
            }
            catch (CommandSyntaxException e) {
                entity = null;
            }
            Class eClass = entity == null ? class_1297.class : entity.getClass();
            String fName = StringArgumentType.getString((CommandContext)ct, (String)"fieldName");
            if ("-THIS-".equals(fName)) {
                return eClass;
            }
            Field field = Reflection.getFieldFromNamed(eClass, fName);
            return field == null ? Object.class : field.getGenericType();
        });
        LiteralArgumentBuilder get = (LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"fieldName", (ArgumentType)StringArgumentType.string()).suggests(suggests).executes(ct -> EntityFieldCommand.getField((CommandContext<class_2168>)ct, AccessingPath.DUMMY))).then(class_2170.method_9244((String)"path", (ArgumentType)pathArgSupplier.get()).executes(ct -> {
            try {
                AccessingPath path = AccessingPathArgumentType.getAccessingPath((CommandContext<class_2168>)ct, "path");
                return EntityFieldCommand.getField((CommandContext<class_2168>)ct, path);
            }
            catch (TranslatableException e) {
                ((class_2168)ct.getSource()).method_9213((class_2561)new class_2585(e.getMessage()));
                return 0;
            }
        })));
        ArgumentBuilder modify = ((LiteralArgumentBuilder)class_2170.method_9247((String)"modify").requires(source -> source.method_9259(1))).then(class_2170.method_9244((String)"fieldName", (ArgumentType)StringArgumentType.string()).suggests(suggests).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"newValue", (ArgumentType)StringArgumentType.string()).executes(ct -> {
            try {
                if (EntityFieldCommand.modifyField(class_2186.method_9313((CommandContext)ct, (String)"target"), StringArgumentType.getString((CommandContext)ct, (String)"fieldName"), StringArgumentType.getString((CommandContext)ct, (String)"newValue"), null, (CommandContext<class_2168>)ct)) {
                    CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.entityfield.modify.success");
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                CommandUtil.error((CommandContext<class_2168>)ct, "cmd.entityfield.modify.failure", e);
                return -1;
            }
        })).then(class_2170.method_9244((String)"path", (ArgumentType)pathArgSupplier.get()).executes(ct -> {
            try {
                if (EntityFieldCommand.modifyField(class_2186.method_9313((CommandContext)ct, (String)"target"), StringArgumentType.getString((CommandContext)ct, (String)"fieldName"), StringArgumentType.getString((CommandContext)ct, (String)"newValue"), AccessingPathArgumentType.getAccessingPath((CommandContext<class_2168>)ct, "path"), (CommandContext<class_2168>)ct)) {
                    CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.entityfield.modify.success");
                    return 1;
                }
                return 0;
            }
            catch (TranslatableException e) {
                ((class_2168)ct.getSource()).method_9213((class_2561)new class_2585(e.getMessage()));
                return 0;
            }
            catch (Exception e) {
                CommandUtil.error((CommandContext<class_2168>)ct, "cmd.entityfield.modify.failure", e);
                return 0;
            }
        }))));
        ArgumentBuilder listAll = class_2170.method_9247((String)"listAvailableFields").executes(ct -> {
            try {
                Set<String> fieldSet = Reflection.getAvailableFieldNames(class_2186.method_9313((CommandContext)ct, (String)"target").getClass());
                String list = String.join((CharSequence)"  ", fieldSet);
                CommandUtil.feedback((CommandContext<? extends class_2168>)ct, list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 1;
        });
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"entityfield").requires(CommandUtil.COMMAND_REQUMENT)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then((ArgumentBuilder)get)).then(modify)).then(listAll));
        dispatcher.register(command);
    }

    private static int getField(CommandContext<class_2168> ct, AccessingPath path) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(ct, (String)"target");
        String name = StringArgumentType.getString(ct, (String)"fieldName");
        if ("-THIS-".equals(name)) {
            try {
                CommandUtil.feedbackRaw(ct, path.access(entity, entity.getClass()));
                return 1;
            }
            catch (AccessingFailureException e) {
                CommandUtil.errorRaw(ct, e.getMessage(), e);
                return 0;
            }
        }
        try {
            Field field = Reflection.getFieldFromNamed(entity.getClass(), name);
            if (field != null) {
                field.setAccessible(true);
                Object ob = field.get(entity);
                CommandUtil.feedbackRaw(ct, ob == null ? "[null]" : path.access(ob, field.getGenericType()));
            } else {
                CommandUtil.error(ct, "cmd.entityfield.nosuchfield");
            }
            return 1;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            CommandUtil.error(ct, "cmd.entityfield.unexpected", e);
            return 0;
        }
        catch (NoSuchFieldError e) {
            CommandUtil.error(ct, "cmd.entityfield.nosuchfield");
            return 0;
        }
        catch (TranslatableException e) {
            CommandUtil.errorRaw(ct, e.getMessage(), e);
            e.printStackTrace();
            return 0;
        }
        catch (AccessingFailureException e) {
            CommandUtil.errorRaw(ct, e.getMessage(), e);
            return 0;
        }
    }

    private static boolean modifyField(class_1297 entity, String fieldName, String newValue, AccessingPath path, CommandContext<class_2168> ct) throws IllegalAccessException, CommandSyntaxException, AccessingFailureException {
        Type type;
        Object obj;
        if ("-THIS-".equals(fieldName)) {
            obj = entity;
            type = entity.getClass();
        } else {
            Field field = Reflection.getFieldFromNamed(entity.getClass(), fieldName);
            if (field == null) {
                throw new IllegalArgumentException("cmd.entityfield.nosuchfield");
            }
            field.setAccessible(true);
            if (path == null) {
                try {
                    field.set(entity, Literal.parse(newValue).get(field.getGenericType()));
                }
                catch (InvalidLiteralException e) {
                    String msg = e.getMessage();
                    CommandUtil.error(ct, msg == null ? "~null~" : msg, e);
                    return false;
                }
                catch (IllegalArgumentException e) {
                    CommandUtil.errorWithArgs(ct, "cmd.entityfield.modify.dismatch", field.getType().getCanonicalName());
                    return false;
                }
                return true;
            }
            obj = field.get(entity);
            type = field.getGenericType();
        }
        try {
            path.write(obj, type, newValue);
            return true;
        }
        catch (AccessingFailureException e) {
            CommandUtil.errorRaw(ct, e.getMessage(), e);
            return false;
        }
    }
}

