/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.command.EnumSetArgumentType;
import lovexyn0827.mess.export.ExportTask;
import lovexyn0827.mess.export.SaveComponent;
import lovexyn0827.mess.export.WorldGenType;
import lovexyn0827.mess.mixins.ServerCommandSourceAccessor;
import lovexyn0827.mess.util.FormattedText;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ExportSaveCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        SuggestionProvider regionSuggest = (ct, b) -> {
            ExportSaveCommand.getExportTask((CommandContext<class_2168>)ct).listRegionNames().forEach(arg_0 -> ((SuggestionsBuilder)b).suggest(arg_0));
            return b.buildFuture();
        };
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"exportsave").requires(CommandUtil.COMMAND_REQUMENT)).then(class_2170.method_9247((String)"addRegion").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"corner1", (ArgumentType)class_2264.method_9701()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"corner2", (ArgumentType)class_2264.method_9701()).executes(ExportSaveCommand::addRegionInCurrentDimension)).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ExportSaveCommand::addRegion))))))).then(class_2170.method_9247((String)"deleteRegion").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(regionSuggest).executes(ExportSaveCommand::delRegion)))).then(class_2170.method_9247((String)"preview").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(regionSuggest).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(ExportSaveCommand::addPreview))))).then(class_2170.method_9247((String)"export").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"worldgen", (ArgumentType)StringArgumentType.word()).suggests(CommandUtil.immutableSuggestions((Object[])WorldGenType.values())).executes(ExportSaveCommand::export))))).then(class_2170.method_9247((String)"listRegions").executes(ct -> {
            ExportTask task = ExportSaveCommand.getExportTask((CommandContext<class_2168>)ct);
            task.listRegions().forEach(r -> CommandUtil.feedbackRaw((CommandContext<? extends class_2168>)ct, r));
            return 1;
        }))).then(class_2170.method_9247((String)"reset").executes(ct -> {
            ExportTask.reset(((ServerCommandSourceAccessor)ct.getSource()).getOutput());
            return 1;
        }))).then(class_2170.method_9247((String)"addComponent").then(class_2170.method_9244((String)"comp", (ArgumentType)EnumSetArgumentType.of(SaveComponent.class)).executes(ExportSaveCommand::addComponent)))).then(class_2170.method_9247((String)"removeComponent").then(class_2170.method_9244((String)"comp", (ArgumentType)EnumSetArgumentType.of(SaveComponent.class)).executes(ExportSaveCommand::removeComponent)))).then(class_2170.method_9247((String)"listComponents").executes(ExportSaveCommand::listComponents));
        dispatcher.register(command);
    }

    private static int addRegion(CommandContext<class_2168> ct) throws CommandSyntaxException {
        ExportTask task = ExportSaveCommand.getExportTask(ct);
        String name = StringArgumentType.getString(ct, (String)"name");
        if (task.listRegionNames().contains(name)) {
            CommandUtil.error(ct, "cmd.general.dupname");
            return 0;
        }
        class_2265 corner1 = class_2264.method_9702(ct, (String)"corner1");
        class_2265 corner2 = class_2264.method_9702(ct, (String)"corner2");
        task.addRegion(name, new class_1923(corner1.field_10708 >> 4, corner1.field_10707 >> 4), new class_1923(corner2.field_10708 >> 4, corner2.field_10707 >> 4), class_2181.method_9289(ct, (String)"dimension"));
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    private static int addRegionInCurrentDimension(CommandContext<class_2168> ct) throws CommandSyntaxException {
        ExportTask task = ExportSaveCommand.getExportTask(ct);
        String name = StringArgumentType.getString(ct, (String)"name");
        if (task.listRegionNames().contains(name)) {
            CommandUtil.error(ct, "cmd.general.dupname");
            return 0;
        }
        class_2265 corner1 = class_2264.method_9702(ct, (String)"corner1");
        class_2265 corner2 = class_2264.method_9702(ct, (String)"corner2");
        task.addRegion(name, new class_1923(corner1.field_10708 >> 4, corner1.field_10707 >> 4), new class_1923(corner2.field_10708 >> 4, corner2.field_10707 >> 4), ((class_2168)ct.getSource()).method_9225());
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    private static int delRegion(CommandContext<class_2168> ct) {
        String name;
        ExportTask task = ExportSaveCommand.getExportTask(ct);
        if (task.deleteRegion(name = StringArgumentType.getString(ct, (String)"name"))) {
            CommandUtil.feedback(ct, "cmd.general.success");
        } else {
            CommandUtil.errorWithArgs(ct, "cmd.general.nodef", name);
        }
        return 1;
    }

    private static int addPreview(CommandContext<class_2168> ct) {
        ExportTask task = ExportSaveCommand.getExportTask(ct);
        task.drawPreview(StringArgumentType.getString(ct, (String)"name"), IntegerArgumentType.getInteger(ct, (String)"ticks"));
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    private static int export(CommandContext<class_2168> ct) {
        Path out;
        long start = class_156.method_648();
        ExportTask task = ExportSaveCommand.getExportTask(ct);
        WorldGenType wg = WorldGenType.valueOf(StringArgumentType.getString(ct, (String)"worldgen"));
        try {
            out = task.export(StringArgumentType.getString(ct, (String)"name"), wg);
            if (out == null) {
                CommandUtil.error(ct, "cmd.exportsave.failexp");
                return 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            CommandUtil.error(ct, "cmd.exportsave.failexp");
            return 0;
        }
        CommandUtil.feedbackWithArgs(ct, "cmd.exportsave.success", (double)(class_156.method_648() - start) / 1.0E9);
        class_5250 link = new FormattedText("cmd.exportsave.saveto", "n", true, out.getFileName()).asMutableText().method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11746, out.toAbsolutePath().toString())));
        ((class_2168)ct.getSource()).method_9226((class_2561)link, false);
        return 1;
    }

    private static ExportTask getExportTask(CommandContext<class_2168> ct) {
        return ExportTask.of(((ServerCommandSourceAccessor)ct.getSource()).getOutput(), ((class_2168)ct.getSource()).method_9211());
    }

    private static int addComponent(CommandContext<class_2168> ct) {
        Set<SaveComponent> set = EnumSetArgumentType.getEnums(ct, "comp");
        ExportTask task = ExportSaveCommand.getExportTask(ct);
        task.addComponents(set);
        CommandUtil.feedbackWithArgs(ct, "cmd.exportsave.addcomp", set.size(), set);
        return 1;
    }

    private static int removeComponent(CommandContext<class_2168> ct) {
        Set<SaveComponent> set = EnumSetArgumentType.getEnums(ct, "comp");
        ExportTask task = ExportSaveCommand.getExportTask(ct);
        task.omitComponents(set);
        CommandUtil.feedbackWithArgs(ct, "cmd.exportsave.remcomp", set.size(), set);
        return 1;
    }

    private static int listComponents(CommandContext<class_2168> ct) {
        for (SaveComponent c : ExportSaveCommand.getExportTask(ct).getComponents()) {
            CommandUtil.feedbackRaw(ct, c.name());
        }
        return 1;
    }
}

