/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.util.phase.TickingPhase;
import lovexyn0827.mess.util.phase.TickingPhaseArgumentType;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_310;
import org.apache.commons.lang3.mutable.MutableInt;

public class LagCommand {
    private static final Set<LaggingEvent> ONGOING_LAGGING_EVENTS = new HashSet<LaggingEvent>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lag").requires(CommandUtil.COMMAND_REQUMENT)).then(class_2170.method_9247((String)"once").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"nanoseconds", (ArgumentType)LongArgumentType.longArg()).executes(LagCommand::lagServer)).then(class_2170.method_9244((String)"thread", (ArgumentType)StringArgumentType.word()).suggests((ct, b) -> {
            for (MainThread t : MainThread.values()) {
                if (!t.available()) continue;
                b.suggest(t.name());
            }
            return b.buildFuture();
        }).executes(LagCommand::lag))))).then(class_2170.method_9247((String)"while").then(class_2170.method_9244((String)"nanoseconds", (ArgumentType)LongArgumentType.longArg()).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"phase", (ArgumentType)TickingPhaseArgumentType.phaseArg()).executes(LagCommand::lagForAWhile)))));
        dispatcher.register(command);
    }

    private static int lagServer(CommandContext<class_2168> ct) {
        long nanos = LongArgumentType.getLong(ct, (String)"nanoseconds");
        try {
            Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            CommandUtil.error(ct, "cmd.general.unexpected", e);
        }
        CommandUtil.feedback(ct, "cmd.lag.done");
        return 1;
    }

    private static int lag(CommandContext<class_2168> ct) {
        long nanos = LongArgumentType.getLong(ct, (String)"nanoseconds");
        try {
            MainThread thread = MainThread.valueOf(StringArgumentType.getString(ct, (String)"thread"));
            if (!thread.available()) {
                CommandUtil.error(ct, "cmd.lag.unsupported");
            }
            MutableInt result = new MutableInt(1);
            Runnable lagAsync = () -> {
                try {
                    Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
                    ((class_2168)ct.getSource()).method_9211().execute(() -> CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.lag.done"));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ((class_2168)ct.getSource()).method_9211().execute(() -> CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.general.unexpected"));
                    result.setValue(0);
                }
            };
            switch (thread) {
                case CLIENT: {
                    class_310.method_1551().execute(lagAsync);
                    break;
                }
                case SERVER: {
                    return LagCommand.lagServer(ct);
                }
            }
            return result.getValue();
        }
        catch (IllegalArgumentException e) {
            CommandUtil.errorWithArgs(ct, "cmd.general.nodef", StringArgumentType.getString(ct, (String)"thread"));
            e.printStackTrace();
            return 0;
        }
    }

    private static int lagForAWhile(CommandContext<class_2168> ct) {
        long nanos = LongArgumentType.getLong(ct, (String)"nanoseconds");
        int ticks = IntegerArgumentType.getInteger(ct, (String)"ticks");
        TickingPhase phase = TickingPhaseArgumentType.getPhase(ct, "phase");
        TickingPhase.Event event = (p, w) -> {
            try {
                Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                CommandUtil.error(ct, "cmd.general.unexpected", e);
            }
        };
        ONGOING_LAGGING_EVENTS.add(new LaggingEvent(event, phase, ((class_2168)ct.getSource()).method_9211().method_30002().method_8510() + (long)ticks));
        phase.addEvent(event);
        CommandUtil.feedback(ct, "cmd.general.success");
        return 1;
    }

    public static void tick() {
        Iterator<LaggingEvent> itr = ONGOING_LAGGING_EVENTS.iterator();
        while (itr.hasNext()) {
            LaggingEvent e = itr.next();
            if (MessMod.INSTANCE.getGameTime() < e.expiration) continue;
            itr.remove();
            e.phase.removeEvent(e.event);
        }
    }

    private static enum MainThread {
        SERVER(true),
        CLIENT(false);

        private final boolean supportsDedicatedEnv;

        private MainThread(boolean supportsDedicatedEnv) {
            this.supportsDedicatedEnv = supportsDedicatedEnv;
        }

        public boolean available() {
            return this.supportsDedicatedEnv || !MessMod.isDedicatedEnv();
        }
    }

    private static final class LaggingEvent {
        protected final TickingPhase.Event event;
        protected final TickingPhase phase;
        protected final long expiration;

        protected LaggingEvent(TickingPhase.Event event, TickingPhase phase, long expiration) {
            this.event = event;
            this.phase = phase;
            this.expiration = expiration;
        }
    }
}

