/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.electronic;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.electronic.LocalOscilscopeDataStorage;
import lovexyn0827.mess.electronic.OscilscopeDataSender;
import lovexyn0827.mess.electronic.OscilscopeDataStorage;
import lovexyn0827.mess.electronic.RemoteOscilscopeDataSender;
import lovexyn0827.mess.electronic.RemoteOscilscopeDataStorage;
import lovexyn0827.mess.network.Channels;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.ServerMicroTime;
import lovexyn0827.mess.util.phase.ServerTickingPhase;
import lovexyn0827.mess.util.phase.TickingPhase;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3528;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class Oscilscope {
    private static final byte DIGITAL_MODE = 0;
    private static final byte TRIG_MODE = 1;
    private static final byte TRIG_LEVEL = 2;
    private static final byte VISIBILITY = 3;
    private final Map<Pair<class_5321<class_1937>, class_2338>, Channel> channels = new HashMap<Pair<class_5321<class_1937>, class_2338>, Channel>();
    private final Int2ObjectMap<Channel> channelsById = new Int2ObjectOpenHashMap();
    private final OscilscopeDataSender dataSender;
    private final OscilscopeDataStorage dataStorage;
    private int nextChannelId = 0;
    private boolean digitalMode = false;

    public Oscilscope() {
        if (MessMod.isDedicatedEnv()) {
            if (MessMod.isDedicatedServerEnv()) {
                this.dataSender = new RemoteOscilscopeDataSender();
                this.dataStorage = null;
            } else {
                this.dataSender = null;
                this.dataStorage = new RemoteOscilscopeDataStorage();
            }
        } else {
            LocalOscilscopeDataStorage localStroage = new LocalOscilscopeDataStorage();
            this.dataSender = localStroage;
            this.dataStorage = localStroage;
        }
    }

    public void update(class_3218 world, class_2338 pos) {
        int level = Oscilscope.getReceivedLevelUnbounded(world, pos);
        Pair key = new Pair((Object)world.method_27983(), (Object)pos);
        if (this.channels.containsKey(key)) {
            this.channels.get(key).update(level);
        } else {
            int color = world.method_8320((class_2338)pos.method_10074()).method_26205((class_1922)world, (class_2338)pos).field_16011 | 0xFF000000;
            Channel newChannel = new Channel(world.method_27983(), pos, color);
            this.addChannel((Pair<class_5321<class_1937>, class_2338>)key, newChannel);
            this.dataSender.sendNewChannel(newChannel);
            newChannel.update(level);
        }
    }

    private static int getReceivedLevelUnbounded(class_3218 world, class_2338 pos) {
        int i = Integer.MIN_VALUE;
        for (class_2350 direction : class_2350.values()) {
            int j = world.method_8499(pos.method_10093(direction), direction);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public OscilscopeDataSender getDataSender() {
        return this.dataSender;
    }

    public OscilscopeDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public void setDigitalMode(boolean digitalMode) {
        this.digitalMode = digitalMode;
        this.uploadConfig((byte)0, buf -> buf.writeBoolean(digitalMode));
    }

    public void sendAllChannelsTo(class_3222 player) {
        this.dataSender.sendChannelsTo(this.channels.values(), player);
    }

    public boolean isDigitalMode() {
        return this.digitalMode;
    }

    private void addChannel(Pair<class_5321<class_1937>, class_2338> key, Channel ch) {
        this.channels.put(key, ch);
        this.channelsById.put(ch.id, (Object)ch);
    }

    @Environment(value=EnvType.CLIENT)
    Channel deserializeChannel(class_2487 tag) {
        int id = tag.method_10550("Id");
        class_5321 dim = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)class_2960.method_12829((String)tag.method_10558("Dimension")));
        int[] posArr = tag.method_10561("Pos");
        class_2338 pos = new class_2338(posArr[0], posArr[1], posArr[2]);
        int color = tag.method_10550("Color");
        TrigMode trigMode = TrigMode.values()[tag.method_10550("TrigMode")];
        int trigLevel = tag.method_10550("TrigLevel");
        Pair key = new Pair((Object)dim, (Object)pos);
        Channel newCh = new Channel(id, dim, pos, color, trigMode, trigLevel);
        this.addChannel((Pair<class_5321<class_1937>, class_2338>)key, newCh);
        return newCh;
    }

    @Nullable
    Channel getChannel(int id) {
        return (Channel)this.channelsById.get(id);
    }

    @Environment(value=EnvType.CLIENT)
    private void uploadConfig(byte type, Consumer<class_2540> writer) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte((int)type);
        writer.accept(buf);
        class_2817 pkt = new class_2817(Channels.OSCILSCOPE_CONF, buf);
        MessMod.INSTANCE.getClientNetworkHandler().send(pkt);
    }

    public void handleConfigPacket(class_2540 buf) {
        class_2658 broadcastPkt = new class_2658(Channels.OSCILSCOPE_CONF_BROADCAST, new class_2540(buf.copy()));
        this.applyConfigPacket(buf);
        MessMod.INSTANCE.getServerNetworkHandler().sendToEveryone(broadcastPkt);
    }

    @Environment(value=EnvType.CLIENT)
    public void handleConfigBroadcastPacket(class_2540 buf) {
        this.applyConfigPacket(buf);
    }

    private void applyConfigPacket(class_2540 buf) {
        switch (buf.readByte()) {
            case 0: {
                this.digitalMode = buf.readBoolean();
                break;
            }
            case 1: {
                this.getChannel(buf.readInt()).trigMode = TrigMode.values()[buf.readInt()];
                break;
            }
            case 2: {
                this.getChannel(buf.readInt()).trigLevel = buf.readInt();
                break;
            }
            case 3: {
                this.getChannel(buf.readInt()).visible = buf.readBoolean();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleDataPacket(class_2540 buf) {
        if (this.dataStorage instanceof RemoteOscilscopeDataStorage) {
            ((RemoteOscilscopeDataStorage)this.dataStorage).handlePacket(buf);
        }
    }

    final class Channel {
        private final int id;
        private final class_5321<class_1937> dimension;
        private final class_2338 pos;
        private final int color;
        private TrigMode trigMode = TrigMode.NONE;
        private int trigLevel = 1;
        private int prevLevel = -1;
        private boolean visible = true;
        private final class_3528<TickingPhase.Event> updater;
        private boolean activeUpdate;
        @Environment(value=EnvType.CLIENT)
        private Consumer<Channel> changeListener;

        private Channel(class_5321<class_1937> dimension, class_2338 pos, int color) {
            this.id = Oscilscope.this.nextChannelId++;
            this.dimension = dimension;
            this.pos = pos;
            this.color = color;
            this.updater = new class_3528(() -> (phase, world) -> {
                if (world != null && !world.field_9236 && world.method_27983() == this.dimension) {
                    this.update(Oscilscope.getReceivedLevelUnbounded((class_3218)world, pos));
                }
            });
            this.setActiveUpdate(true);
        }

        private Channel(int id, class_5321<class_1937> dimension, class_2338 pos, int color, TrigMode trigMode, int trigLevel) {
            this.id = id;
            this.dimension = dimension;
            this.pos = pos;
            this.color = color;
            this.trigMode = trigMode;
            this.trigLevel = trigLevel;
            this.updater = new class_3528(() -> (p, w) -> {});
        }

        void update(int level) {
            boolean fallingEdge;
            boolean risingEdge;
            if (level == this.prevLevel) {
                return;
            }
            Oscilscope.this.dataSender.sendEdge(this, level);
            if (Oscilscope.this.digitalMode) {
                risingEdge = level > 0 && this.prevLevel <= 0;
                fallingEdge = level <= 0 && this.prevLevel > 0;
            } else {
                risingEdge = level >= this.trigLevel && this.prevLevel < this.trigLevel;
                boolean bl = fallingEdge = level < this.trigLevel && this.prevLevel >= this.trigLevel;
            }
            if (this.isVisible() && this.trigMode.shouldTrigger(risingEdge, fallingEdge)) {
                this.trigger(risingEdge);
            }
            this.prevLevel = level;
        }

        private void trigger(boolean risingEdge) {
            Trigger trig = new Trigger(this, ServerMicroTime.current(), risingEdge);
            Oscilscope.this.dataSender.sendTrigger(trig);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hash(this.dimension, this.pos);
            return result;
        }

        void setActiveUpdate(boolean activeUpdate) {
            if (activeUpdate == this.activeUpdate) {
                return;
            }
            this.activeUpdate = activeUpdate;
            if (activeUpdate) {
                ServerTickingPhase.addEventToAll((TickingPhase.Event)this.updater.method_15332());
            } else {
                ServerTickingPhase.removeEventFromAll((TickingPhase.Event)this.updater.method_15332());
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Channel other = (Channel)obj;
            return Objects.equals(this.dimension, other.dimension) && Objects.equals(this.pos, other.pos);
        }

        public String toString() {
            return "CH" + this.id;
        }

        int getColor() {
            return this.color;
        }

        @Environment(value=EnvType.CLIENT)
        void setChangeListener(Consumer<Channel> listener) {
            this.changeListener = listener;
        }

        @Environment(value=EnvType.CLIENT)
        void notifyChangeListener() {
            if (this.changeListener != null) {
                this.changeListener.accept(this);
            }
        }

        @Environment(value=EnvType.CLIENT)
        void setTrigMode(TrigMode mode) {
            if (mode == this.trigMode) {
                return;
            }
            this.trigMode = mode;
            Oscilscope.this.uploadConfig((byte)1, buf -> {
                buf.writeInt(this.id);
                buf.writeInt(this.trigMode.ordinal());
            });
            this.notifyChangeListener();
        }

        @Environment(value=EnvType.CLIENT)
        void setTrigLevel(int level) {
            if (level == this.trigLevel) {
                return;
            }
            this.trigLevel = level;
            Oscilscope.this.uploadConfig((byte)2, buf -> {
                buf.writeInt(this.id);
                buf.writeInt(this.trigLevel);
            });
            this.notifyChangeListener();
        }

        public TrigMode getTrigMode() {
            return this.trigMode;
        }

        public int getTrigLevel() {
            return this.trigLevel;
        }

        public int getId() {
            return this.id;
        }

        public String getDimensionId() {
            return this.dimension.method_29177().method_12832();
        }

        public class_2338 getPos() {
            return this.pos;
        }

        @Environment(value=EnvType.CLIENT)
        public void setVisible(boolean visible) {
            if (visible == this.visible) {
                return;
            }
            this.visible = visible;
            if (OptionManager.hayOscilloscopeChannelVisibilityBroadcast) {
                Oscilscope.this.uploadConfig((byte)3, buf -> {
                    buf.writeInt(this.id);
                    buf.writeBoolean(visible);
                });
                this.notifyChangeListener();
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isUpdatingActively() {
            return this.activeUpdate;
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10569("Id", this.id);
            tag.method_10582("Dimension", this.dimension.method_29177().toString());
            tag.method_10539("Pos", new int[]{this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()});
            tag.method_10569("Color", this.color);
            tag.method_10569("TrigMode", this.trigMode.ordinal());
            tag.method_10569("TrigLevel", this.trigLevel);
            return tag;
        }
    }

    static enum TrigMode {
        RISING(true, false),
        FALLING(false, true),
        BOTH(true, true),
        NONE(false, false);

        private final boolean trigOnRising;
        private final boolean trigOnFailing;

        private TrigMode(boolean trigOnRising, boolean trigOnFailing) {
            this.trigOnRising = trigOnRising;
            this.trigOnFailing = trigOnFailing;
        }

        boolean shouldTrigger(boolean risingEdge, boolean fallingEdge) {
            return risingEdge && this.trigOnRising || fallingEdge && this.trigOnFailing;
        }
    }

    static class Trigger {
        final Channel channel;
        final ServerMicroTime time;
        final boolean rising;

        public Trigger(Channel channel, ServerMicroTime time, boolean rising) {
            this.channel = channel;
            this.time = time;
            this.rising = rising;
        }
    }

    static class Edge {
        final ServerMicroTime time;
        final int newLevel;

        public Edge(ServerMicroTime time, int newLevel) {
            this.time = time;
            this.newLevel = newLevel;
        }
    }
}

