/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.electronic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.electronic.Oscilscope;
import lovexyn0827.mess.util.ServerMicroTime;

abstract class OscilscopeDataStorage {
    private static final double PURGE_START_THRESHOLD = 1.5;
    private final Map<Oscilscope.Channel, List<Oscilscope.Edge>> waveData = new ConcurrentHashMap<Oscilscope.Channel, List<Oscilscope.Edge>>();
    private final ConcurrentLinkedDeque<Oscilscope.Trigger> newTriggers = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<Oscilscope.Trigger> triggers = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedQueue<Oscilscope.Channel> newChannels = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedDeque<Oscilscope.Channel> channels = new ConcurrentLinkedDeque();
    private int storageDepth;

    OscilscopeDataStorage() {
    }

    static OscilscopeDataStorage get() {
        return MessMod.INSTANCE.getOscilscope().getDataStorage();
    }

    protected Map<Oscilscope.Channel, List<Oscilscope.Edge>> getWaveData() {
        return this.waveData;
    }

    public void takeUnprocessedTriggers(Consumer<Oscilscope.Trigger> op) {
        while (!this.newTriggers.isEmpty()) {
            op.accept(this.newTriggers.poll());
        }
    }

    public void takeNewChannels(Consumer<Oscilscope.Channel> op) {
        while (!this.newChannels.isEmpty()) {
            op.accept(this.newChannels.poll());
        }
    }

    private final void purge() {
        if (this.storageDepth <= 0) {
            return;
        }
        HashMap<Oscilscope.Channel, ServerMicroTime> lowerBounds = new HashMap<Oscilscope.Channel, ServerMicroTime>();
        this.waveData.forEach((ch, wave) -> {
            if ((double)wave.size() < (double)this.storageDepth * 1.5) {
                return;
            }
            int trimStart = wave.size() - this.storageDepth - 1;
            int trimEnd = wave.size() - 1;
            Oscilscope.Edge[] trimmed = wave.subList(trimStart, trimEnd).toArray(new Oscilscope.Edge[this.storageDepth]);
            wave.clear();
            for (Oscilscope.Edge edge : trimmed) {
                wave.add(edge);
            }
            ServerMicroTime oldestEdgeTime = wave.isEmpty() ? ServerMicroTime.END_OF_TIME : ((Oscilscope.Edge)wave.get((int)0)).time;
            lowerBounds.put((Oscilscope.Channel)ch, oldestEdgeTime);
        });
        this.purgeTriggers(this.triggers, lowerBounds);
        this.purgeTriggers(this.newTriggers, lowerBounds);
    }

    private void purgeTriggers(Deque<Oscilscope.Trigger> triggers, Map<Oscilscope.Channel, ServerMicroTime> lowerBounds) {
        Iterator<Oscilscope.Trigger> itr = triggers.iterator();
        while (itr.hasNext()) {
            Oscilscope.Trigger head = itr.next();
            if (head.time.compareTo(lowerBounds.getOrDefault(head.channel, ServerMicroTime.PRE_HISTORY)) < 0) {
                itr.remove();
            } else {
                lowerBounds.remove(head.channel);
            }
            if (!lowerBounds.isEmpty()) continue;
            break;
        }
    }

    public void reset() {
        this.waveData.clear();
        this.triggers.clear();
    }

    protected void addTrigger(Oscilscope.Trigger trig) {
        this.triggers.add(trig);
        this.newTriggers.add(trig);
    }

    protected void addChannel(Oscilscope.Channel channel) {
        this.channels.add(channel);
        this.newChannels.add(channel);
    }

    protected void addEdge(Oscilscope.Channel channel, Oscilscope.Edge edge) {
        this.waveData.computeIfAbsent(channel, k -> Collections.synchronizedList(new ArrayList())).add(edge);
        this.purge();
    }

    public ConcurrentLinkedDeque<Oscilscope.Trigger> getTriggerHistory() {
        return this.triggers;
    }

    public ConcurrentLinkedDeque<Oscilscope.Channel> getAllChannels() {
        return this.channels;
    }

    private static int findEndPos(List<Oscilscope.Edge> all, long bound, boolean findLast) {
        int left = 0;
        int right = all.size() - 1;
        int candidate = -1;
        if (findLast) {
            while (left <= right) {
                int mid = (left + right) / 2;
                Oscilscope.Edge midElem = all.get(mid);
                if (midElem.time.gameTime <= bound) {
                    candidate = mid;
                    left = mid + 1;
                    continue;
                }
                right = mid - 1;
            }
        } else {
            while (left <= right) {
                int mid = (left + right) / 2;
                Oscilscope.Edge midElem = all.get(mid);
                if (midElem.time.gameTime >= bound) {
                    candidate = mid;
                    right = mid - 1;
                    continue;
                }
                left = mid + 1;
            }
        }
        return candidate;
    }

    Map<Oscilscope.Channel, List<Oscilscope.Edge>> getWaveData(long fromTick, long toTick, boolean digitalMode) {
        Comparator<Oscilscope.Channel> cmp = Comparator.comparingInt(Oscilscope.Channel::getId);
        TreeMap<Oscilscope.Channel, List<Oscilscope.Edge>> result = new TreeMap<Oscilscope.Channel, List<Oscilscope.Edge>>(cmp);
        this.getWaveData().forEach((channel, data) -> {
            if (!channel.isVisible() || data.isEmpty()) {
                return;
            }
            int from = OscilscopeDataStorage.findEndPos(data, fromTick, false);
            int to = OscilscopeDataStorage.findEndPos(data, toTick, true);
            if (to == -1) {
                return;
            }
            List<Oscilscope.Edge> dataWithinRange = from == -1 ? Collections.emptyList() : data.subList(from, to + 1);
            ArrayList<Oscilscope.Edge> clipedData = new ArrayList<Oscilscope.Edge>();
            if (from == 0) {
                clipedData.add(new Oscilscope.Edge(ServerMicroTime.PRE_HISTORY, 0));
            } else if (from == -1) {
                clipedData.add((Oscilscope.Edge)data.get(data.size() - 1));
            } else if (digitalMode) {
                clipedData.add(new Oscilscope.Edge(ServerMicroTime.PRE_HISTORY, ((Oscilscope.Edge)data.get((int)(from - 1))).newLevel));
            } else {
                clipedData.add((Oscilscope.Edge)data.get(from - 1));
            }
            if (digitalMode) {
                Oscilscope.Edge prev = (Oscilscope.Edge)clipedData.get(0);
                for (Oscilscope.Edge edge : dataWithinRange) {
                    if (!(prev.newLevel > 0 ^ edge.newLevel > 0)) continue;
                    clipedData.add(edge);
                    prev = edge;
                }
            } else {
                clipedData.addAll(dataWithinRange);
            }
            result.put((Oscilscope.Channel)channel, (List<Oscilscope.Edge>)clipedData);
        });
        return result;
    }

    void setStorageDepth(int depth) {
        this.storageDepth = depth;
    }

    int getStorageDepth() {
        return this.storageDepth;
    }
}

