/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.log.chunk;

import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.log.AbstractAchivingLogger;
import lovexyn0827.mess.log.CsvWriter;
import lovexyn0827.mess.log.chunk.ChunkEvent;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.AccessingPath;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ChunkBehaviorLogger
extends AbstractAchivingLogger {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private static final ParameterizedType CUSTOM_LINE_INPUT_TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Class[]{class_3218.class, Object.class};
        }

        @Override
        public Type getRawType() {
            return Pair.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private CsvWriter currentLog;
    private final HashSet<ChunkEvent> subscribedEvents = new HashSet();
    private boolean working = false;
    private final LinkedHashMap<String, AccessingPath> customColumns = new LinkedHashMap();

    public ChunkBehaviorLogger(MinecraftServer server) {
        super(server);
    }

    public void start() throws IOException {
        File logFile = this.getLogPath().resolve(DATE_FORMAT.format(new Date()) + ".csv").toFile();
        FileWriter writer = new FileWriter(logFile);
        CsvWriter.Builder csvBuilder = new CsvWriter.Builder();
        csvBuilder.addColumn("Event").addColumn("Pos").addColumn("Dimension").addColumn("GameTime").addColumn("RealTime").addColumn("Thread").addColumn("Cause").addColumn("Addition");
        this.customColumns.keySet().forEach(csvBuilder::addColumn);
        this.currentLog = csvBuilder.build(writer);
        this.working = true;
        this.hasCreatedAnyLog = true;
    }

    public void stop() throws IOException {
        this.working = false;
        this.currentLog.close();
        this.currentLog = null;
    }

    public void subscribeAll(Set<ChunkEvent> events) {
        this.subscribedEvents.addAll(events);
    }

    public void unsubscribeAll(Set<ChunkEvent> events) {
        this.subscribedEvents.removeAll(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onEvent(ChunkEvent event, long pos, class_2960 dim, Thread thread, Object cause, Object addition) {
        if (this.working && this.subscribedEvents.contains((Object)event)) {
            if (this.customColumns.isEmpty()) {
                this.currentLog.println(event.name(), pos == class_1923.field_17348 ? null : new class_1923(pos), dim, this.server.method_30002().method_8510(), class_156.method_648(), thread.getName(), cause, addition);
            } else {
                Object[] data = new Object[this.customColumns.size() + 8];
                data[0] = event.name();
                data[1] = pos == class_1923.field_17348 ? null : new class_1923(pos);
                data[2] = dim;
                data[3] = this.server.method_30002().method_8510();
                data[4] = class_156.method_648();
                data[5] = thread.getName();
                data[6] = cause;
                data[7] = addition;
                class_3218 world = this.server.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)dim));
                int dataPos = 8;
                Pair pair = new Pair((Object)world, addition);
                for (AccessingPath path : this.customColumns.values()) {
                    try {
                        data[dataPos] = path.access(pair, CUSTOM_LINE_INPUT_TYPE);
                    }
                    catch (AccessingFailureException e) {
                        data[dataPos] = e.getShortenedMsg();
                    }
                    finally {
                        ++dataPos;
                    }
                }
                this.currentLog.println(data);
            }
        }
    }

    @Override
    protected String getLogFolderName() {
        return "chunklog";
    }

    public Set<ChunkEvent> listSubscribedEvents() {
        return Collections.unmodifiableSet(this.subscribedEvents);
    }

    public boolean isWorking() {
        return this.working;
    }

    public static boolean shouldSkip() {
        ChunkBehaviorLogger logger = MessMod.INSTANCE.getChunkLogger();
        return logger == null || !logger.isWorking();
    }

    public boolean addColumn(String name, AccessingPath path) {
        if (this.customColumns.containsKey(name)) {
            return false;
        }
        this.customColumns.put(name, path);
        return true;
    }

    public boolean removeColumn(String name) {
        return this.customColumns.remove(name) != null;
    }

    public Set<String> getColumns() {
        return this.customColumns.keySet();
    }
}

