/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.OptionParser;

public class IntegerParser
implements OptionParser<Integer> {
    @Override
    public Integer tryParse(String str) throws InvalidOptionException {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new InvalidOptionException("opt.err.rint", new Object[0]);
        }
    }

    @Override
    public String serialize(Integer val) {
        return Integer.toString(val);
    }

    public static class HotbarLength
    extends IntegerParser {
        @Override
        public Integer tryParse(String str) throws InvalidOptionException {
            Integer i = super.tryParse(str);
            if (i > 0 && i <= 36) {
                return i;
            }
            throw new InvalidOptionException("opt.err.rhotbar", new Object[0]);
        }
    }

    public static class NonNegative
    extends IntegerParser {
        @Override
        public Integer tryParse(String str) throws InvalidOptionException {
            Integer i = super.tryParse(str);
            if (i >= 0) {
                return i;
            }
            throw new InvalidOptionException("opt.err.rnonnegative", new Object[0]);
        }
    }

    public static class Positive
    extends IntegerParser {
        @Override
        public Integer tryParse(String str) throws InvalidOptionException {
            Integer i = super.tryParse(str);
            if (i > 0) {
                return i;
            }
            throw new InvalidOptionException("opt.err.rpositive", new Object[0]);
        }
    }
}

