/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.export.SaveComponent;
import lovexyn0827.mess.mixins.WorldSavePathMixin;
import lovexyn0827.mess.options.BooleanParser;
import lovexyn0827.mess.options.FloatParser;
import lovexyn0827.mess.options.IntegerParser;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.Label;
import lovexyn0827.mess.options.ListParser;
import lovexyn0827.mess.options.Option;
import lovexyn0827.mess.options.OptionSet;
import lovexyn0827.mess.options.OptionWrapper;
import lovexyn0827.mess.options.RangeParser;
import lovexyn0827.mess.options.StringParser;
import lovexyn0827.mess.rendering.BlockInfoRenderer;
import lovexyn0827.mess.rendering.FrozenUpdateMode;
import lovexyn0827.mess.rendering.hud.AlignMode;
import lovexyn0827.mess.util.CommandTextFieldWidget;
import lovexyn0827.mess.util.PulseRecorder;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.blame.BlamingMode;
import lovexyn0827.mess.util.blame.Confidence;
import lovexyn0827.mess.util.i18n.I18N;
import lovexyn0827.mess.util.i18n.Language;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OptionManager {
    public static final SortedMap<String, OptionWrapper> OPTIONS = Stream.of(OptionManager.class.getFields()).filter(f -> f.isAnnotationPresent(Option.class)).sorted((a, b) -> Comparator.naturalOrder().compare(a.getName(), b.getName())).collect(TreeMap::new, (map, f) -> map.put(f.getName(), new OptionWrapper((Field)f)), Map::putAll);
    private static OptionSet activeOptionSet;
    static final Map<String, CustomOptionApplicator> CUSTOM_APPLICATION_BEHAVIORS;
    static final Map<String, CustomOptionValidator> CUSTOM_OPTION_VALIDATORS;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean accessingPathDynamicAutoCompletion;
    @Option(defaultValue="STANDARD", parserClass=AccessingPath.InitializationStrategy.Parser.class, label={Label.MESSMOD})
    public static AccessingPath.InitializationStrategy accessingPathInitStrategy;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static boolean allowSelectingDeadEntities;
    @Option(defaultValue="false", parserClass=BooleanParser.class, deprecated=true, label={Label.INTERACTION_TWEAKS})
    public static boolean allowTargetingSpecialEntities;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.RESEARCH})
    public static boolean antiHostCheating;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean attackableTnt;
    @Option(defaultValue="POSSIBLE", parserClass=Confidence.Parser.class, label={Label.MESSMOD})
    public static Confidence blameThreshold;
    @Option(defaultValue="DISABLED", parserClass=BlamingMode.Parser.class, label={Label.MESSMOD})
    public static BlamingMode blamingMode;
    @Option(defaultValue="NORMALLY", parserClass=FrozenUpdateMode.Parser.class, label={Label.MESSMOD})
    public static FrozenUpdateMode blockInfoRendererUpdateInFrozenTicks;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static boolean blockPlacementHistory;
    @Option(defaultValue="COLLISION", parserClass=BlockInfoRenderer.ShapeType.Parser.class, label={Label.MESSMOD, Label.RENDERER})
    public static BlockInfoRenderer.ShapeType blockShapeToBeRendered;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.RENDERER})
    public static boolean chunkLoadingInfoRenderer;
    @Option(defaultValue="4", parserClass=IntegerParser.NonNegative.class, label={Label.MESSMOD, Label.RENDERER})
    public static int chunkLoadingInfoRenderRadius;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean chunkLogAutoArchiving;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean clayBlockPlacer;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean commandExecutionRequirment;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.REDSTONE})
    public static boolean craftingTableBUD;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static boolean creativeNoVoidDamage;
    @Option(defaultValue="NaN", suggestions={"0.05", "0.10", "NaN"}, parserClass=FloatParser.NaNablePositive.class, label={Label.INTERACTION_TWEAKS})
    public static float creativeUpwardsSpeed;
    @Option(defaultValue="false", experimental=true, parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS, Label.BUGFIX})
    public static boolean debugStickSkipsInvaildState;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean dedicatedServerCommands;
    @Option(defaultValue="REGION,POI", parserClass=SaveComponent.DefaultListParser.class, suggestions={"REGION,POI", "REGION,GAMERULES,POI", "[]"}, label={Label.MESSMOD})
    public static List<SaveComponent> defaultSaveComponents;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.CHUNK, Label.MESSMOD})
    public static boolean detailedChunkTaskLogging;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.RESEARCH, Label.MESSMOD})
    public static boolean directChunkAccessForMessMod;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean disableChunkLoadingCheckInCommands;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS, Label.CHUNK})
    public static boolean disableClientChunkUnloading;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean disableCreativeForcePickup;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean disableEnchantCommandRestriction;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.EXPLOSION, Label.BREAKING_OPTIMIZATION})
    public static boolean disableExplosionExposureCalculation;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean disableItemUsageCooldown;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.ENTITY, Label.RESEARCH})
    public static boolean disableProjectileRandomness;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.ENTITY, Label.RESEARCH, Label.MESSMOD})
    public static boolean dumpTargetEntityDataOnClient;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.ENTITY, Label.RESEARCH, Label.MESSMOD})
    public static boolean dumpTargetEntityDataWithPaper;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.ENTITY, Label.RESEARCH, Label.MESSMOD})
    public static boolean dumpTargetEntityDataWithCtrlC;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.ENTITY, Label.RESEARCH, Label.MESSMOD})
    public static boolean dumpTargetEntityNbt;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.ENTITY, Label.RESEARCH, Label.MESSMOD})
    public static boolean dumpTargetEntitySummonCommand;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static boolean enabledTools;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean endEyeTeleport;
    @Option(defaultValue="1.0", parserClass=FloatParser.NonNegative.class, suggestions={"0.0", "1.0"}, label={Label.EXPLOSION, Label.RESEARCH, Label.ENTITY})
    public static float entityExplosionImpulseScale;
    @Option(defaultValue="false", experimental=true, parserClass=BooleanParser.class, label={Label.EXPLOSION, Label.RESEARCH, Label.ENTITY})
    public static boolean entityExplosionInfluence;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.EXPLOSION, Label.RENDERER, Label.ENTITY, Label.MESSMOD})
    public static boolean entityExplosionRaysVisiblity;
    @Option(defaultValue="300", parserClass=IntegerParser.class, label={Label.EXPLOSION, Label.RENDERER, Label.MESSMOD})
    public static int entityExplosionRaysLifetime;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean entityLogAutoArchiving;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean expandedStructureBlockRenderingRange;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static boolean fillHistory;
    @Option(defaultValue="POSITIVE", parserClass=PulseRecorder.Mode.Parser.class, label={Label.REDSTONE, Label.MESSMOD})
    public static PulseRecorder.Mode fletchingTablePulseDetectingMode;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.REDSTONE})
    public static boolean fletchingTablePulseDetector;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.RENDERER, Label.MISC})
    public static boolean flowerFieldRenderer;
    @Option(defaultValue="16", parserClass=IntegerParser.Positive.class, label={Label.RENDERER, Label.MISC})
    public static int flowerFieldRendererRadius;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.RENDERER, Label.MISC})
    public static boolean flowerFieldRendererSingleLayer;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.CHUNK})
    public static boolean generateChunkGrid;
    @Option(defaultValue="2.0", experimental=true, parserClass=FloatParser.Positive.class, label={Label.RESEARCH, Label.ENTITY}, suggestions={"2.0"})
    public static float getEntityRangeExpansion;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.RESEARCH, Label.REDSTONE})
    public static boolean hayOscilloscope;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.RESEARCH, Label.REDSTONE, Label.MESSMOD})
    public static boolean hayOscilloscopeChannelVisibilityBroadcast;
    @Option(defaultValue="false", parserClass=BooleanParser.class, deprecated=true, environment={EnvType.CLIENT}, label={Label.MISC, Label.MESSMOD})
    public static boolean hideSurvivalSaves;
    @Option(defaultValue="TOP_RIGHT", parserClass=AlignMode.Parser.class, label={Label.MESSMOD, Label.RENDERER})
    public static AlignMode hudAlignMode;
    @Option(defaultValue="(BL)^2/(mR)", parserClass=StringParser.class, deprecated=true, label={Label.MESSMOD, Label.RENDERER})
    public static String hudStyles;
    @Option(defaultValue="1.0", parserClass=FloatParser.Positive.class, label={Label.MESSMOD, Label.RENDERER})
    public static float hudTextSize;
    @Option(defaultValue="9", parserClass=IntegerParser.HotbarLength.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static int hotbarLength;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static boolean independentEntityPickerForInfomation;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean interactableB36;
    @Option(defaultValue="-FOLLOW_SYSTEM_SETTINGS-", parserClass=Language.Parser.class, label={Label.HIGHLIGHT, Label.MESSMOD})
    public static String language;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.REDSTONE})
    public static boolean loomWaveGenerator;
    @Option(defaultValue="10", parserClass=IntegerParser.Positive.class, label={Label.RESEARCH, Label.BUGFIX})
    public static int maxClientTicksPerFrame;
    @Option(defaultValue="180", parserClass=FloatParser.Positive.class, label={Label.INTERACTION_TWEAKS, Label.MESSMOD})
    public static float maxEndEyeTpRadius;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean minecartPlacementOnNonRailBlocks;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean mobFastKill;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.ENTITY, Label.BREAKING_OPTIMIZATION})
    public static boolean optimizedEntityPushing;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean playerInputsWhenScreenOpened;
    @Option(defaultValue="295", parserClass=IntegerParser.class, label={Label.MESSMOD})
    public static int playerInputsWhenScreenOpenedHotkey;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.CHUNK, Label.ENTITY})
    public static boolean projectileChunkLoading;
    @Option(defaultValue="3", parserClass=IntegerParser.NonNegative.class, label={Label.CHUNK, Label.ENTITY, Label.MESSMOD})
    public static int projectileChunkLoadingRange;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.CHUNK, Label.ENTITY, Label.MESSMOD})
    public static boolean projectileChunkLoadingPermanence;
    @Option(defaultValue="1.0", parserClass=FloatParser.class, label={Label.RESEARCH, Label.ENTITY})
    public static float projectileRandomnessScale;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static boolean quickMobMounting;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean quickStackedEntityKilling;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS, Label.MESSMOD})
    public static boolean quickStackedEntityKillingOneTypeOnly;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean railNoAutoConnection;
    @Option(defaultValue="[]", parserClass=ListParser.Ticket.class, label={Label.CHUNK, Label.RESEARCH})
    public static List<class_3230<?>> rejectChunkTicket;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.RENDERER})
    public static boolean renderBlockShape;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.ENTITY})
    public static boolean resistanceReducesVoidDamage;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.RENDERER})
    public static boolean renderFluidShape;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.RENDERER})
    public static boolean renderRedstoneGateInfo;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.HIGHLIGHT, Label.RENDERER})
    public static boolean serverSyncedBox;
    @Option(defaultValue="-1", parserClass=FloatParser.class, label={Label.MESSMOD, Label.RENDERER})
    public static float serverSyncedBoxRenderRange;
    @Option(defaultValue="NORMALLY", parserClass=FrozenUpdateMode.Parser.class, label={Label.MESSMOD, Label.RENDERER})
    public static FrozenUpdateMode serverSyncedBoxUpdateModeInFrozenTicks;
    @Option(defaultValue="[]", parserClass=RangeParser.ChunkStatusRange.class, label={Label.CHUNK, Label.RESEARCH})
    public static List<RangeParser.ChunkStatusRange.ChunkStatusSorter> skippedGenerationStages;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.CHUNK, Label.BREAKING_OPTIMIZATION})
    public static boolean skipUnloadedChunkInRaycasting;
    @Option(defaultValue=" ", parserClass=CommandTextFieldWidget.CharSetParser.class, label={Label.INTERACTION_TWEAKS}, suggestions={" ", " ,=:.([{}])"})
    public static CharSet smartCursorCustomWordDelimiters;
    @Option(defaultValue="VANILLA", parserClass=CommandTextFieldWidget.CursorMode.Parser.class, environment={EnvType.CLIENT}, label={Label.HIGHLIGHT, Label.INTERACTION_TWEAKS})
    public static CommandTextFieldWidget.CursorMode smartCursorMode;
    @Option(defaultValue="true", parserClass=BooleanParser.class, deprecated=true, label={Label.MESSMOD, Label.RENDERER})
    public static boolean stableHudLocation;
    @Option(defaultValue="false", experimental=true, parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean strictAccessingPathParsing;
    @Option(defaultValue="false", experimental=true, parserClass=BooleanParser.class, label={Label.MISC})
    public static boolean superSuperSecretSetting;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean survivalStatusBarInCreativeMode;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.INTERACTION_TWEAKS})
    public static boolean survivalXpBarInCreativeMode;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.CHUNK, Label.ENTITY})
    public static boolean tntChunkLoading;
    @Option(defaultValue="false", parserClass=BooleanParser.class, label={Label.CHUNK, Label.ENTITY, Label.MESSMOD})
    public static boolean tntChunkLoadingPermanence;
    @Option(defaultValue="3", parserClass=IntegerParser.NonNegative.class, label={Label.CHUNK, Label.ENTITY, Label.MESSMOD})
    public static int tntChunkLoadingRange;
    @Option(defaultValue="1.0", parserClass=FloatParser.Positive.class, label={Label.HIGHLIGHT, Label.RENDERER})
    public static float tpsGraphScale;
    @Option(defaultValue="[]", parserClass=ListParser.DebugRender.class, label={Label.HIGHLIGHT, Label.RENDERER})
    public static List<Either<Field, String>> vanillaDebugRenderers;

    private static void setOptionSet(OptionSet set) {
        activeOptionSet = set;
        set.activiate();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            MessMod.LOGGER.info("Loaded {} MessMod config from {}", (Object)OPTIONS.size(), (Object)set.getReadablePathStr());
            OPTIONS.values().stream().map(o -> o.name + ": " + set.getSerialized(o.name)).forEach(arg_0 -> ((Logger)MessMod.LOGGER).debug(arg_0));
        }
    }

    public static boolean isValidOptionName(String name) {
        return OPTIONS.containsKey(name);
    }

    public static void onReceivedOptions(class_2540 in) throws IOException {
        OptionManager.setOptionSet(OptionSet.fromPacket(in));
    }

    private static void registerCustomApplicator(String name, CustomOptionApplicator behavior) {
        CUSTOM_APPLICATION_BEHAVIORS.put(name, behavior);
    }

    private static void registerCustomValidator(String name, CustomOptionValidator validator) {
        CUSTOM_OPTION_VALIDATORS.put(name, validator);
    }

    private static void registerCustomHandlers(String name, CustomOptionValidator validator, CustomOptionApplicator behavior) {
        CUSTOM_APPLICATION_BEHAVIORS.put(name, behavior);
        CUSTOM_OPTION_VALIDATORS.put(name, validator);
    }

    public static void updateServer(@Nullable MinecraftServer ms) {
        if (ms != null) {
            Path p = ms.method_27050(WorldSavePathMixin.create("mcwmem.prop"));
            OptionManager.setOptionSet(OptionSet.load(p.toFile()));
        } else {
            activeOptionSet.save();
            OptionManager.setOptionSet(OptionSet.GLOBAL);
        }
    }

    public static void loadFromRemoteServer(class_2540 data) {
        OptionManager.setOptionSet(OptionSet.fromPacket(data));
    }

    public static void loadSingleFromRemoteServer(class_2540 data) {
        if (activeOptionSet == OptionSet.GLOBAL) {
            MessMod.LOGGER.error("Trying to load options to global option set!");
            return;
        }
        String name = data.method_19772();
        String value = data.method_19772();
        try {
            activeOptionSet.set(name, value);
        }
        catch (InvalidOptionException e) {
            MessMod.LOGGER.error("Received incorrect option {}={}: {}", (Object)name, (Object)value, (Object)e.getLocalizedMessage());
        }
    }

    public static void reload() {
        activeOptionSet.reload();
    }

    public static void sendOptionsTo(class_3222 player) {
        player.field_13987.method_14364((class_2596)activeOptionSet.toPacket());
    }

    public static OptionSet getActiveOptionSet() {
        return activeOptionSet;
    }

    public static OptionSet getGlobalOptionSet() {
        return OptionSet.GLOBAL;
    }

    static {
        CUSTOM_APPLICATION_BEHAVIORS = Maps.newHashMap();
        CUSTOM_OPTION_VALIDATORS = Maps.newHashMap();
        CustomOptionValidator checkLithium = (newVal, ct) -> {
            if (FabricLoader.getInstance().isModLoaded("lithium") && ((Boolean)newVal).booleanValue()) {
                throw new InvalidOptionException("opt.err.lithium", new Object[0]);
            }
        };
        OptionManager.registerCustomValidator("entityExplosionInfluence", checkLithium);
        OptionManager.registerCustomValidator("disableExplosionExposureCalculation", checkLithium);
        CustomOptionValidator requireCarpet = (newVal, ct) -> {
            if (!(FabricLoader.getInstance().isModLoaded("carpet") || newVal instanceof Boolean && !((Boolean)newVal).booleanValue())) {
                throw new InvalidOptionException("opt.err.reqcarpet", new Object[0]);
            }
        };
        OptionManager.registerCustomValidator("blockInfoRendererUpdateInFrozenTicks", requireCarpet);
        OptionManager.registerCustomApplicator("hudStyles", (newVal, ct) -> {
            if (!MessMod.isDedicatedServerEnv() && MessMod.INSTANCE.getClientHudManager() != null) {
                MessMod.INSTANCE.getClientHudManager().updateStyle((String)newVal);
            }
        });
        OptionManager.registerCustomHandlers("language", (newVal, ct) -> {
            boolean forceLoad = ((String)newVal).endsWith("_FORCELOAD");
            String id = ((String)newVal).replace("_FORCELOAD", "");
            if (!I18N.canUseLanguage(id, forceLoad)) {
                throw new InvalidOptionException("Language " + id + " is unsupported or incomplete.", new Object[0]);
            }
        }, (newVal, ct) -> {
            boolean forceLoad = ((String)newVal).endsWith("_FORCELOAD");
            String id = ((String)newVal).replace("_FORCELOAD", "");
            if (!I18N.setLanguage(id, forceLoad)) {
                throw new IllegalStateException("Option language is not validated!");
            }
        });
        OptionManager.registerCustomValidator("expandedStructureBlockRenderingRange", (newVal, ct) -> {
            MutableBoolean conflict = new MutableBoolean(false);
            FabricLoader.getInstance().getModContainer("carpet").ifPresent(mod -> {
                Version ver = mod.getMetadata().getVersion();
                if (ver instanceof SemanticVersion) {
                    SemanticVersion semVer = (SemanticVersion)ver;
                    try {
                        conflict.setValue(SemanticVersion.parse((String)"1.4.24").compareTo(semVer) <= 0);
                    }
                    catch (VersionParsingException versionParsingException) {
                        // empty catch block
                    }
                }
            });
            if (conflict.booleanValue()) {
                throw new InvalidOptionException("opt.err.conflict.carpet.1425", new Object[0]);
            }
        });
        OPTIONS.values().forEach(o -> {
            if (!I18N.EN_US.containsKey(String.format("opt.%s.desc", o.name))) {
                MessMod.LOGGER.warn("The description of option {} is missing!", (Object)o.name);
            }
        });
        OptionManager.setOptionSet(OptionSet.GLOBAL);
    }

    @FunctionalInterface
    static interface CustomOptionValidator {
        public void validate(@Nullable Object var1, @Nullable CommandContext<class_2168> var2) throws InvalidOptionException;
    }

    @FunctionalInterface
    static interface CustomOptionApplicator {
        public void onOptionUpdate(Object var1, @Nullable CommandContext<class_2168> var2);
    }
}

