/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import java.util.Collections;
import java.util.Set;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.Option;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.options.OptionWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OptionParser<T> {
    public T tryParse(String var1) throws InvalidOptionException;

    public String serialize(T var1);

    default public String serializeObj(Object val) {
        return this.serialize(val);
    }

    @NotNull
    default public Set<String> createSuggestions() {
        return Collections.emptySet();
    }

    default public void validate(String in) throws InvalidOptionException {
        this.tryParse(in);
    }

    public static OptionParser<?> of(Option o) {
        try {
            return o.parserClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static OptionParser<?> of(String optionName) {
        OptionWrapper o = (OptionWrapper)OptionManager.OPTIONS.get(optionName);
        if (o != null) {
            return OptionParser.of(o.option);
        }
        return null;
    }
}

