/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.ListParser;
import net.minecraft.class_2806;

public abstract class RangeParser<T extends Comparable<T>>
extends ListParser<T> {
    public RangeParser(BiMap<String, T> elements) {
        super(elements);
    }

    @Override
    public List<T> tryParse(String str) throws InvalidOptionException {
        if ("[]".equals(str) || str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        String[] splited = str.split(",");
        for (int i = 0; i < splited.length; ++i) {
            if ("...".equals(splited[i])) {
                Comparable max;
                if (i == 0 && i < splited.length - 1) {
                    max = (Comparable)this.elements.get((Object)splited[i + 1]);
                    if (max == null) {
                        throw new InvalidOptionException("cmd.general.nodef", splited[i + 1]);
                    }
                    this.elements.values().stream().filter(e -> e.compareTo(max) <= 0).forEach(result::add);
                    ++i;
                    continue;
                }
                if (i == splited.length - 1 && i > 0) {
                    Comparable min = (Comparable)this.elements.get((Object)splited[i - 1]);
                    if (min == null) {
                        throw new InvalidOptionException("cmd.general.nodef", splited[i - 1]);
                    }
                    this.elements.values().stream().filter(e -> e.compareTo(min) >= 0).forEach(result::add);
                    continue;
                }
                if (i <= 0 || i >= splited.length - 1) continue;
                max = (Comparable)this.elements.get((Object)splited[i + 1]);
                if (max == null) {
                    throw new InvalidOptionException("cmd.general.nodef", splited[i + 1]);
                }
                Comparable min = (Comparable)this.elements.get((Object)splited[i - 1]);
                if (min == null) {
                    throw new InvalidOptionException("cmd.general.nodef", splited[i - 1]);
                }
                this.elements.values().stream().filter(e -> e.compareTo(min) >= 0 && e.compareTo(max) <= 0).forEach(result::add);
                ++i;
                continue;
            }
            Comparable val = (Comparable)this.elements.get((Object)splited[i]);
            if (val == null) {
                throw new InvalidOptionException("cmd.general.nodef", splited[i]);
            }
            result.add(val);
        }
        return result;
    }

    public static final class ChunkStatusRange
    extends RangeParser<ChunkStatusSorter> {
        private static final ImmutableBiMap<String, ChunkStatusSorter> VANILLA_CHUNK_STATUSES;

        public ChunkStatusRange() {
            super(VANILLA_CHUNK_STATUSES);
        }

        static {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            Stream.of(class_2806.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getType().equals(class_2806.class)).map(f -> {
                try {
                    return (class_2806)f.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }).filter(status -> status != class_2806.field_12794 && status != class_2806.field_12803).map(status -> new ChunkStatusSorter((class_2806)status, status.method_16559())).forEach(wrapped -> builder.put((Object)wrapped.status.method_12172(), wrapped));
            VANILLA_CHUNK_STATUSES = builder.build();
        }

        public static class ChunkStatusSorter
        implements Comparable<ChunkStatusSorter> {
            public final class_2806 status;
            private final int ordinal;

            public ChunkStatusSorter(class_2806 status, int ordinal) {
                this.status = status;
                this.ordinal = ordinal;
            }

            public int hashCode() {
                return this.status.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj.getClass() == ChunkStatusSorter.class) {
                    ChunkStatusSorter other = (ChunkStatusSorter)obj;
                    return this.status.equals(other.status);
                }
                return false;
            }

            @Override
            public int compareTo(ChunkStatusSorter o) {
                return this.ordinal - o.ordinal;
            }
        }
    }
}

