/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering;

import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.fakes.ServerWorldInterface;
import lovexyn0827.mess.mixins.AbstractRedstoneGateBlockMixin;
import lovexyn0827.mess.options.EnumParser;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.rendering.FrozenUpdateMode;
import lovexyn0827.mess.rendering.RenderedBox;
import lovexyn0827.mess.rendering.RenderedLine;
import lovexyn0827.mess.rendering.RenderedText;
import lovexyn0827.mess.rendering.ShapeSender;
import lovexyn0827.mess.rendering.ShapeSpace;
import lovexyn0827.mess.util.CarpetUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class BlockInfoRenderer {
    private static final ShapeSpace BLOCK_INFO_SPACE = new ShapeSpace("block_info");
    private MinecraftServer server;

    public void initializate(MinecraftServer server) {
        this.server = server;
    }

    public void uninitializate() {
        this.server = null;
    }

    public void tick() {
        ShapeSender sr = MessMod.INSTANCE.shapeSender;
        if (this.server != null && sr != null) {
            boolean frozen = CarpetUtil.isTickFrozen();
            if (frozen && OptionManager.blockInfoRendererUpdateInFrozenTicks == FrozenUpdateMode.PAUSE) {
                return;
            }
            for (class_3222 e : this.server.method_3760().method_14571()) {
                if (!frozen || OptionManager.blockInfoRendererUpdateInFrozenTicks == FrozenUpdateMode.NORMALLY) {
                    sr.clearSpaceFromServer(BLOCK_INFO_SPACE, e);
                }
                class_243 from = new class_243(e.method_23317(), e.method_23320(), e.method_23321());
                class_243 to = from.method_1019(e.method_5720().method_1021(16.0));
                class_3218 serverWorld = this.server.method_3847(e.method_5770().method_27983());
                class_3218 world = OptionManager.directChunkAccessForMessMod ? ((ServerWorldInterface)serverWorld).toNoChunkLoadingWorld() : serverWorld;
                ShapeType type = OptionManager.blockShapeToBeRendered;
                class_2338 pos = world.method_17742(new class_3959(from, to, type.mjType, class_3959.class_242.field_1347, (class_1297)e)).method_17777();
                class_3610 fluid = world.method_8316(pos);
                long time = serverWorld.method_8510();
                class_5321 worldKey = serverWorld.method_27983();
                if (!fluid.method_15769() && OptionManager.renderFluidShape) {
                    class_243 flow = fluid.method_15758((class_1922)world, pos);
                    float fluidHeight = fluid.method_20785();
                    String info = Float.toString(fluidHeight) + '(' + fluid.method_15761() + ')' + '\n' + flow;
                    class_238 fluidBox = fluid.method_17776((class_1922)world, pos).method_1107().method_996(pos);
                    sr.addShape(new RenderedBox(fluidBox, -16776961, 0, 1, time), (class_5321<class_1937>)worldKey, BLOCK_INFO_SPACE, e);
                    sr.addShape(new RenderedText(info, class_243.method_24955((class_2382)pos).method_1031(0.0, 1.0, 0.0), -16776961, 1, time), (class_5321<class_1937>)worldKey, BLOCK_INFO_SPACE, e);
                    if (flow.method_1033() == 0.0) continue;
                    class_243 displayedFlow = flow.method_1021(-0.5).method_1031((double)pos.method_10263() + 0.5, (double)((float)pos.method_10264() + fluidHeight / 2.0f), (double)pos.method_10260() + 0.5);
                    sr.addShape(new RenderedLine(displayedFlow, displayedFlow.method_1019(flow), 255, 1, time), (class_5321<class_1937>)worldKey, BLOCK_INFO_SPACE, e);
                    continue;
                }
                class_2680 block = world.method_8320(pos);
                class_265 voxels = type.getter.getFrom(block, (class_1922)serverWorld, pos);
                if (!voxels.method_1110() && OptionManager.renderBlockShape) {
                    voxels.method_1090().forEach(b -> sr.addShape(new RenderedBox(b.method_996(pos), -7864065, 0, 1, time), (class_5321<class_1937>)worldKey, BLOCK_INFO_SPACE, e));
                }
                if (!(block.method_26204() instanceof class_2312) || !OptionManager.renderRedstoneGateInfo) continue;
                class_2312 gate = (class_2312)block.method_26204();
                int out = (Boolean)block.method_11654((class_2769)class_2741.field_12484) != false ? ((AbstractRedstoneGateBlockMixin)gate).getOutputRSLevel((class_1922)world, pos, block) : 0;
                String info = "Output :" + Integer.toString(out);
                sr.addShape(new RenderedText(info, class_243.method_24955((class_2382)pos).method_1031(0.0, 1.0, 0.0), 65535, 1, time), (class_5321<class_1937>)worldKey, BLOCK_INFO_SPACE, e);
            }
        }
    }

    public static enum ShapeType {
        OUTLINE(class_3959.class_3960.field_17559, class_4970.class_4971::method_26218),
        SIDES(class_3959.class_3960.field_17558, class_4970.class_4971::method_26222),
        VISUAL(class_3959.class_3960.field_23142, (b, w, p) -> b.method_26202(w, p, null)),
        RAYCAST(class_3959.class_3960.field_17559, class_4970.class_4971::method_26224),
        COLLISION(class_3959.class_3960.field_17558, class_4970.class_4971::method_26220);

        public final class_3959.class_3960 mjType;
        public final ShapeGetter getter;

        private ShapeType(class_3959.class_3960 mjType, ShapeGetter getter) {
            this.mjType = mjType;
            this.getter = getter;
        }

        public static class Parser
        extends EnumParser<ShapeType> {
            public Parser() {
                super(ShapeType.class);
            }
        }
    }

    static interface ShapeGetter {
        public class_265 getFrom(class_2680 var1, class_1922 var2, class_2338 var3);
    }
}

