/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering;

import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.rendering.RenderedBox;
import lovexyn0827.mess.rendering.ShapeSender;
import lovexyn0827.mess.rendering.ShapeSpace;
import lovexyn0827.mess.util.phase.ServerTickingPhase;
import lovexyn0827.mess.util.phase.TickingPhase;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class ChunkLoadingInfoRenderer {
    private static final ShapeSpace CHUNK_LOADING = new ShapeSpace("chunk_loading");
    private final TickingPhase.Event updateEvent = this::tick;

    public ChunkLoadingInfoRenderer() {
        ServerTickingPhase.CHUNK.addEvent(this.updateEvent);
    }

    public void tick(TickingPhase phase, class_1937 worldIn) {
        class_3218 world = (class_3218)worldIn;
        ShapeSender ss = MessMod.INSTANCE.shapeSender;
        if (!OptionManager.chunkLoadingInfoRenderer || ss == null) {
            return;
        }
        class_5321 worldKey = world.method_27983();
        int radius = OptionManager.chunkLoadingInfoRenderRadius;
        int diameter = 2 * radius + 1;
        for (class_3222 player : world.method_18456()) {
            if (worldKey == class_1937.field_25179) {
                ss.clearSpaceFromServer(CHUNK_LOADING, player);
            }
            if (!player.method_24518(class_1802.field_8864)) continue;
            class_3215 scm = world.method_14178();
            int x = player.field_6024 - radius;
            int z = player.field_5980 - radius;
            for (int dx = 0; dx < diameter; ++dx) {
                for (int dz = 0; dz < diameter; ++dz) {
                    class_1923 pos = new class_1923(x + dx, z + dz);
                    int blockX = pos.method_8326() + 7;
                    int blockZ = pos.method_8328() + 7;
                    class_2818 chunk = scm.method_12126(x + dx, z + dz, false);
                    double height = chunk != null ? (double)chunk.method_12032(class_2902.class_2903.field_13202).method_12603(8, 8) : player.method_23318();
                    int color = scm.method_20591(pos) ? -16777025 : (scm.method_20529(pos.method_8323()) ? 0xFF00BF : -1077952577);
                    RenderedBox marker = new RenderedBox(blockX, height, blockZ, (double)blockX + 2.0, height + 0.5, (double)blockZ + 2.0, color | 0xFF, color, 2, world.method_8510());
                    ss.addShape(marker, (class_5321<class_1937>)worldKey, CHUNK_LOADING, player);
                }
            }
        }
    }

    public void close() {
        ServerTickingPhase.CHUNK.removeEvent(this.updateEvent);
    }
}

