/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import lovexyn0827.mess.rendering.RenderedBitmap;
import lovexyn0827.mess.rendering.RenderedBox;
import lovexyn0827.mess.rendering.RenderedLine;
import lovexyn0827.mess.rendering.RenderedText;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public abstract class Shape {
    protected static final BiMap<String, Class<? extends Shape>> IDS = HashBiMap.create();
    public final int color;
    public final int life;
    protected float r;
    protected float g;
    protected float b;
    protected float a;
    protected float fr;
    protected float fg;
    protected float fb;
    protected float fa;
    private long createdTime;
    double renderEpsilon = 0.0;
    private int fill;

    protected Shape(int color, int fill, int life, long gt) {
        this.color = color;
        this.fill = fill;
        this.life = life;
        this.createdTime = gt;
        this.fr = (float)(fill >> 24 & 0xFF) / 255.0f;
        this.fg = (float)(fill >> 16 & 0xFF) / 255.0f;
        this.fb = (float)(fill >> 8 & 0xFF) / 255.0f;
        this.fa = (float)(fill & 0xFF) / 255.0f;
        this.r = (float)(color >> 24 & 0xFF) / 255.0f;
        this.g = (float)(color >> 16 & 0xFF) / 255.0f;
        this.b = (float)(color >> 8 & 0xFF) / 255.0f;
        this.a = (float)(color & 0xFF) / 255.0f;
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract void renderFaces(class_289 var1, class_287 var2, double var3, double var5, double var7, float var9);

    @Environment(value=EnvType.CLIENT)
    protected abstract void renderLines(class_289 var1, class_287 var2, double var3, double var5, double var7, float var9);

    protected abstract boolean shouldRender(class_5321<class_1937> var1);

    protected boolean isExpired(long gameTime) {
        return (long)this.life + this.createdTime - gameTime < 0L;
    }

    @Nullable
    protected class_2487 toTag(class_2487 tag) {
        tag.method_10582("ID", (String)IDS.inverse().get(this.getClass()));
        tag.method_10569("Color", this.color);
        tag.method_10569("Fill", this.fill);
        tag.method_10569("Life", this.life);
        tag.method_10544("GT", this.createdTime);
        return tag;
    }

    protected void close() {
    }

    @Nullable
    public static Shape fromTag(class_2487 tag) {
        switch (tag.method_10580("ID").method_10714()) {
            case "box": {
                return new RenderedBox(tag.method_10574("X0"), tag.method_10574("Y0"), tag.method_10574("Z0"), tag.method_10574("X1"), tag.method_10574("Y1"), tag.method_10574("Z1"), tag.method_10550("Color"), tag.method_10550("Fill"), tag.method_10550("Life"), tag.method_10537("GT"));
            }
            case "line": {
                return new RenderedLine(new class_243(tag.method_10574("X0"), tag.method_10574("Y0"), tag.method_10574("Z0")), new class_243(tag.method_10574("X1"), tag.method_10574("Y1"), tag.method_10574("Z1")), tag.method_10550("Color"), tag.method_10550("Life"), tag.method_10537("GT"));
            }
            case "text": {
                float scale = tag.method_10545("scale") ? tag.method_10583("Scale") : 1.0f;
                return new RenderedText(tag.method_10558("Value"), new class_243(tag.method_10574("X"), tag.method_10574("Y"), tag.method_10574("Z")), tag.method_10550("Color"), scale, tag.method_10550("Life"), tag.method_10537("GT"));
            }
            case "bitmap": {
                return RenderedBitmap.fromTag(tag);
            }
        }
        return null;
    }

    static {
        IDS.put((Object)"box", RenderedBox.class);
        IDS.put((Object)"line", RenderedLine.class);
        IDS.put((Object)"text", RenderedText.class);
        IDS.put((Object)"bitmap", RenderedBitmap.class);
    }
}

