/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering.hud.data;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import lovexyn0827.mess.mixins.BoatEntityAccessor;
import lovexyn0827.mess.rendering.hud.EntityHudUtil;
import lovexyn0827.mess.rendering.hud.data.DataType;
import lovexyn0827.mess.rendering.hud.data.HudLine;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1668;
import net.minecraft.class_1690;
import org.jetbrains.annotations.Nullable;

public enum BuiltinHudInfo implements HudLine
{
    ID("ID", DataType.INTEGER, class_1297::method_5628, null),
    NAME("Name", DataType.STRING, entity -> entity.method_16914() ? entity.method_5797().method_10851() : entity.method_5864().method_5882().replaceFirst("^.+\\u002e", "")),
    POS_X("Pos X", DataType.DOUBLE, class_1297::method_23317),
    POS_Y("Pos Y", DataType.DOUBLE, class_1297::method_23318),
    POS_Z("Pos Z", DataType.DOUBLE, class_1297::method_23321),
    AGE("Age", DataType.INTEGER, e -> e.field_6012),
    MOTION_X("Motion X", DataType.DOUBLE, e -> e.method_18798().field_1352),
    MOTION_Y("Motion Y", DataType.DOUBLE, e -> e.method_18798().field_1351),
    MOTION_Z("Motion Z", DataType.DOUBLE, e -> e.method_18798().field_1350),
    DELTA_X("Delta X", DataType.DOUBLE, e -> e.method_23317() - e.field_6014),
    DELTA_Y("Delta Y", DataType.DOUBLE, e -> e.method_23318() - e.field_6036),
    DELTA_Z("Delta Z", DataType.DOUBLE, e -> e.method_23321() - e.field_5969),
    YAW("Yaw", DataType.FLOAT, e -> Float.valueOf(e.field_6031)),
    PITCH("Pitch", DataType.FLOAT, e -> Float.valueOf(e.field_5965)),
    FALL_DISTANCE("Fall Distance", DataType.FLOAT, e -> Float.valueOf(e.field_6017)),
    GENERAL_FLAGS("State", DataType.STRING, EntityHudUtil::getGeneralFlags),
    FORWARD("Forward", DataType.FLOAT, e -> Float.valueOf(((class_1309)e).field_6250), class_1309.class),
    SIDEWAYS("SideWays", DataType.FLOAT, e -> Float.valueOf(((class_1309)e).field_6212), class_1309.class),
    UPWARD("Upwards", DataType.FLOAT, e -> Float.valueOf(((class_1309)e).field_6227), class_1309.class),
    HEALTH("Health", DataType.FLOAT, e -> Float.valueOf(((class_1309)e).method_6032()), class_1309.class),
    LIVING_FLAGS("Living State", DataType.STRING, e -> EntityHudUtil.getLivingFlags((class_1309)e), class_1309.class),
    MOVEMENT_SPEED("OnLand Speed", DataType.FLOAT, e -> Float.valueOf(((class_1309)e).method_6029()), class_1309.class),
    FLYING_SPEED("Fly Speed", DataType.FLOAT, e -> Float.valueOf(((class_1309)e).field_6281), class_1309.class),
    FUSE("Fuse", DataType.INTEGER, e -> ((class_1541)e).method_6969(), class_1541.class),
    POWER_X("Power X", DataType.DOUBLE, e -> ((class_1668)e).field_7601, class_1668.class),
    POWER_Y("Power Y", DataType.DOUBLE, e -> ((class_1668)e).field_7600, class_1668.class),
    POWER_Z("Power Z", DataType.DOUBLE, e -> ((class_1668)e).field_7599, class_1668.class),
    VELOCITY_DECAY("Decay", DataType.FLOAT, e -> Float.valueOf(((BoatEntityAccessor)e).getVelocityDeacyMCWMEM()), class_1690.class),
    POSE("Pose", DataType.POSE, class_1297::method_18376);

    public static final Map<String, BuiltinHudInfo> BY_TITLE;
    public final String header;
    public final DataType type;
    public final Function<class_1297, Object> getter;
    public final Class<? extends class_1297> classRequirment;

    private BuiltinHudInfo(String header, @Nullable DataType type, Function<class_1297, Object> getter, Class<? extends class_1297> classRequirment) {
        this.header = header;
        this.type = type;
        this.getter = getter;
        this.classRequirment = classRequirment == null ? class_1297.class : classRequirment;
    }

    private BuiltinHudInfo(String header, DataType type, Function<class_1297, Object> getter) {
        this(header, type, getter, null);
    }

    @Override
    public String getFrom(class_1297 in) {
        return this.type.getStringOf(this.getter.apply(in));
    }

    @Override
    public boolean canGetFrom(class_1297 entity) {
        return this.classRequirment.isInstance(entity);
    }

    @Override
    public String getName() {
        return this.header;
    }

    static {
        BY_TITLE = Maps.newHashMap();
        for (BuiltinHudInfo line : BuiltinHudInfo.values()) {
            BY_TITLE.put(line.header, line);
        }
    }
}

