/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering.hud.data;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.rendering.hud.HudType;
import lovexyn0827.mess.rendering.hud.ServerHudManager;
import lovexyn0827.mess.rendering.hud.data.HudLine;
import lovexyn0827.mess.rendering.hud.data.RemoteHudDataStorage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public interface HudDataStorage {
    public int size();

    public Object get(HudLine var1);

    public Iterator<Map.Entry<HudLine, Object>> iterator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void forEach(BiConsumer<String, Object> action) {
        HudDataStorage hudDataStorage = this;
        synchronized (hudDataStorage) {
            this.iterator().forEachRemaining(entry -> action.accept(((HudLine)entry.getKey()).getName(), entry.getValue()));
        }
    }

    public static HudDataStorage create(HudType type) {
        if (MessMod.isDedicatedEnv()) {
            return new RemoteHudDataStorage();
        }
        ServerHudManager shm = MessMod.INSTANCE.getServerHudManager();
        switch (type) {
            case TARGET: {
                return (HudDataStorage)((Object)shm.lookingHud);
            }
            case SERVER_PLAYER: {
                return (HudDataStorage)((Object)shm.playerHudS);
            }
            case CLIENT_PLAYER: {
                return (HudDataStorage)((Object)shm.playerHudC);
            }
            case SIDEBAR: {
                return (HudDataStorage)((Object)shm.sidebar);
            }
        }
        throw new AssertionError();
    }
}

