/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.rendering.hud.data;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lovexyn0827.mess.fakes.HudDataSubscribeState;
import lovexyn0827.mess.network.Channels;
import lovexyn0827.mess.rendering.hud.HudType;
import lovexyn0827.mess.rendering.hud.data.BuiltinHudInfo;
import lovexyn0827.mess.rendering.hud.data.HudDataSender;
import lovexyn0827.mess.rendering.hud.data.HudLine;
import lovexyn0827.mess.rendering.hud.data.SidebarDataSender;
import lovexyn0827.mess.rendering.hud.data.SidebarLine;
import lovexyn0827.mess.util.phase.TickingPhase;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class RemoteHudDataSender
implements HudDataSender {
    protected class_2487 lastData = new class_2487();
    protected final List<HudLine> lines = Lists.newArrayList();
    protected final MinecraftServer server;
    private final HudType type;

    public RemoteHudDataSender(MinecraftServer server, HudType type, boolean addDefaultLines) {
        this.server = server;
        this.type = type;
        if (addDefaultLines) {
            for (BuiltinHudInfo l : BuiltinHudInfo.values()) {
                this.lines.add(l);
            }
        }
    }

    @Override
    public Collection<HudLine> getLines() {
        return this.lines;
    }

    @Override
    public void updateData(class_1297 entity) {
        class_2487 data = new class_2487();
        ArrayList unused = Lists.newArrayList((Iterable)this.lastData.method_10541());
        Stream<HudLine> lines = this.streamAllLines();
        if (entity != null) {
            lines.forEach(l -> {
                if (this.tryPutData(entity, (HudLine)l, data)) {
                    unused.remove(l.getName());
                }
            });
        }
        this.lastData = this.lastData.method_10543(data);
        class_2499 toRemove = new class_2499();
        unused.forEach(n -> {
            toRemove.add((Object)class_2519.method_23256((String)n));
            this.lastData.method_10551(n);
        });
        data.method_10566("ToRemove", (class_2520)toRemove);
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10817((Enum)this.type);
        buffer.method_10794(data);
        class_2658 packet = new class_2658(Channels.HUD, buffer);
        this.server.method_3760().method_14571().stream().filter(p -> ((HudDataSubscribeState)p.field_13987).isSubscribed(this.type)).forEach(p -> p.field_13987.method_14364((class_2596)packet));
    }

    protected Stream<HudLine> streamAllLines() {
        return this.lines.stream();
    }

    private boolean tryPutData(class_1297 entity, HudLine l, class_2487 data) {
        String name = l.getName();
        if (l.canGetFrom(entity)) {
            class_2520 last = this.lastData.method_10580(name);
            String value = l.getFrom(entity);
            if (last == null || !last.method_10714().equals(value)) {
                data.method_10582(name, value);
            }
            return true;
        }
        return false;
    }

    public static class Sidebar
    extends RemoteHudDataSender
    implements SidebarDataSender {
        public Sidebar(MinecraftServer server) {
            super(server, HudType.SIDEBAR, false);
            this.registerTickingEvents();
        }

        @Override
        public void updateData(TickingPhase phase, @Nullable class_1937 world) {
            class_2487 data = new class_2487();
            ArrayList unused = Lists.newArrayList((Iterable)this.lastData.method_10541());
            Stream<HudLine> lines = this.streamAllLines();
            lines.forEach(l -> {
                if (l instanceof SidebarLine) {
                    SidebarLine line = (SidebarLine)l;
                    if (SidebarDataSender.shouldUpdate(line, phase, world)) {
                        Object ob = line.get();
                        data.method_10566(line.getName(), (class_2520)class_2519.method_23256((String)ob.toString()));
                    }
                } else {
                    throw new IllegalStateException("Only SidebarLines are permitted");
                }
                unused.remove(l.getName());
            });
            this.lastData = this.lastData.method_10543(data);
            class_2499 toRemove = new class_2499();
            unused.forEach(n -> toRemove.add((Object)class_2519.method_23256((String)n)));
            data.method_10566("ToRemove", (class_2520)toRemove);
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10817((Enum)HudType.SIDEBAR);
            buffer.method_10794(data);
            class_2658 packet = new class_2658(Channels.HUD, buffer);
            this.server.method_3760().method_14571().stream().forEach(p -> p.field_13987.method_14364((class_2596)packet));
        }

        @Override
        protected Stream<HudLine> streamAllLines() {
            return this.lines.stream();
        }
    }
}

