/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class BlockPlacementHistory {
    private static final ThreadLocal<List<BlockChange>> CURRENT = new ThreadLocal();
    private static final ThreadLocal<class_2487> NEXT_BE = new ThreadLocal();
    private final class_3222 player;
    private final Stack<Operation> history = new Stack();
    private final Stack<Operation> redoQueue = new Stack();

    public BlockPlacementHistory(class_3222 player) {
        this.player = player;
    }

    public void pushSingle(class_2338 pos, class_2680 prevState, class_2680 newState, @Nullable class_2586 prevBlockEntity) {
        this.history.push(new Operation(Collections.singletonList(new BlockChange(this.player.method_14220(), pos, prevState, prevBlockEntity == null ? null : prevBlockEntity.method_11007(new class_2487()), newState, null))));
        this.redoQueue.clear();
    }

    public void beginOperation() {
        CURRENT.set(new ArrayList());
    }

    public static void appendBlockChange(class_3218 world, class_2338 pos, class_2680 prevState, class_2680 newState, @Nullable class_2487 prevBlockEntity, @Nullable class_2487 newBlockEntity) {
        if (prevState.equals(newState) && Objects.equal((Object)prevBlockEntity, (Object)newBlockEntity)) {
            return;
        }
        if (CURRENT.get() == null) {
            return;
        }
        class_2487 be = NEXT_BE.get();
        CURRENT.get().add(new BlockChange(world, pos.method_10062(), prevState, be == null ? prevBlockEntity : be, newState, newBlockEntity));
    }

    public void preparePrevBlockEntityForTheNext(class_2586 be) {
        if (be != null) {
            NEXT_BE.set(be.method_11007(new class_2487()));
        }
    }

    public void endOperation(boolean abort) {
        if (abort) {
            CURRENT.set(null);
        } else {
            this.history.push(new Operation(CURRENT.get()));
            this.redoQueue.clear();
            CURRENT.set(null);
        }
    }

    public void undo() {
        if (this.history.empty()) {
            return;
        }
        Operation o = this.history.pop();
        o.undo();
        this.redoQueue.push(o);
    }

    public void redo() {
        if (this.redoQueue.empty()) {
            return;
        }
        Operation o = this.redoQueue.pop();
        o.redo();
        this.history.push(o);
    }

    private final class Operation {
        private final List<BlockChange> changed;

        protected Operation(List<BlockChange> changed) {
            this.changed = changed;
        }

        void redo() {
            for (BlockChange bc : this.changed) {
                bc.redo();
            }
        }

        void undo() {
            for (BlockChange bc : this.changed) {
                bc.undo();
            }
        }
    }

    private static final class BlockChange {
        protected final class_2338 pos;
        protected final class_2680 prevState;
        protected final class_2680 newState;
        @Nullable
        protected final class_2487 prevBlockEntity;
        @Nullable
        protected final class_2487 newBlockEntity;
        private final class_3218 world;

        BlockChange(class_3218 world, class_2338 pos, class_2680 prevState, class_2487 prevBlockEntity, class_2680 newState, class_2487 newBlockEntity) {
            this.world = world;
            this.pos = pos;
            this.prevState = prevState;
            this.newState = newState;
            this.prevBlockEntity = prevBlockEntity;
            this.newBlockEntity = newBlockEntity;
        }

        public void redo() {
            class_2586 be;
            this.world.method_30092(this.pos, this.newState, 2, 0);
            if (this.newBlockEntity != null && (be = this.world.method_8321(this.pos)) != null) {
                be.method_11014(this.newState, BlockChange.appendLocationalData(this.newBlockEntity, this.pos));
            }
        }

        public void undo() {
            class_2586 be;
            this.world.method_30092(this.pos, this.prevState, 2, 0);
            if (this.prevBlockEntity != null && (be = this.world.method_8321(this.pos)) != null) {
                be.method_11014(this.prevState, BlockChange.appendLocationalData(this.prevBlockEntity, this.pos));
            }
        }

        private static class_2487 appendLocationalData(class_2487 tag, class_2338 pos) {
            tag.method_10569("x", pos.method_10263());
            tag.method_10569("y", pos.method_10264());
            tag.method_10569("z", pos.method_10260());
            return tag;
        }
    }
}

