/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.Optional;
import lovexyn0827.mess.options.EnumParser;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.options.OptionParser;
import lovexyn0827.mess.util.access.AccessingPathArgumentType;
import net.minecraft.class_2172;
import net.minecraft.class_2178;
import net.minecraft.class_2179;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2188;
import net.minecraft.class_2203;
import net.minecraft.class_2212;
import net.minecraft.class_2216;
import net.minecraft.class_2223;
import net.minecraft.class_2232;
import net.minecraft.class_2239;
import net.minecraft.class_2240;
import net.minecraft.class_2257;
import net.minecraft.class_2287;
import net.minecraft.class_2293;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3528;
import net.minecraft.class_4717;
import net.minecraft.class_5250;
import net.minecraft.class_637;
import org.jetbrains.annotations.Nullable;

public class CommandTextFieldWidget
extends class_342 {
    private final CommandDispatcher<class_2172> commandDispatcher = class_310.method_1551().method_1562().method_2886();
    private final boolean requireSlashBeforeCommands;
    private final class_3528<class_4717> commandSuggestor;

    public CommandTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text, boolean requreSlash, class_3528<class_4717> commandSuggestor) {
        super(textRenderer, x, y, width, height, text);
        this.requireSlashBeforeCommands = requreSlash;
        this.commandSuggestor = commandSuggestor;
    }

    protected class_5250 method_25360() {
        return super.method_25360().method_27693(((class_4717)this.commandSuggestor.method_15332()).method_23958());
    }

    @Nullable
    private ArgumentCommandNode<?, ?> getCommandNodeAtCursor() {
        CommandNode parent;
        class_637 source = class_310.method_1551().field_1724.field_3944.method_2875();
        String text = this.method_1882();
        String cmd = text.startsWith("/") ? text.substring(1) : text;
        ParseResults parsed = this.commandDispatcher.parse(cmd, (Object)source);
        try {
            parent = parsed.getContext().findSuggestionContext((int)(this.method_1881() - 1)).parent;
        }
        catch (Exception e) {
            return null;
        }
        Optional<ArgumentCommandNode> child = parent.getChildren().stream().filter(cn -> cn instanceof ArgumentCommandNode).findAny().map(cn -> (ArgumentCommandNode)cn);
        return child.orElseGet(() -> parent instanceof ArgumentCommandNode ? (ArgumentCommandNode)parent : null);
    }

    public int method_1864(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        ArgumentCommandNode<?, ?> argNode;
        if (this.requireSlashBeforeCommands && !this.method_1882().startsWith("/")) {
            return super.method_1864(wordOffset, cursorPosition, skipOverSpaces);
        }
        CursorMode delimDetector = OptionManager.smartCursorMode;
        if (delimDetector.shouldParseCommand) {
            argNode = this.getCommandNodeAtCursor();
            if (argNode == null) {
                return super.method_1864(wordOffset, cursorPosition, skipOverSpaces);
            }
        } else {
            argNode = null;
        }
        int i = cursorPosition;
        boolean reverse = wordOffset < 0;
        int wordsToSkip = Math.abs(wordOffset);
        for (int k = 0; k < wordsToSkip; ++k) {
            if (reverse) {
                while (skipOverSpaces && i > 0 && delimDetector.isWordDelimiter(argNode, this.method_1882().charAt(i - 1), i - 1)) {
                    --i;
                }
                while (i > 0 && !delimDetector.isWordDelimiter(argNode, this.method_1882().charAt(i - 1), i - 1)) {
                    --i;
                }
                continue;
            }
            int len = this.method_1882().length();
            while (i < len && !delimDetector.isWordDelimiter(argNode, this.method_1882().charAt(i), i)) {
                ++i;
            }
            while (skipOverSpaces && i < len && delimDetector.isWordDelimiter(argNode, this.method_1882().charAt(i), i)) {
                ++i;
            }
        }
        return i;
    }

    public static enum CursorMode {
        VANILLA(false){

            @Override
            boolean isWordDelimiter(ArgumentCommandNode<?, ?> node, char ch, int pos) {
                return ch == ' ';
            }
        }
        ,
        NON_LITERAL(false){

            @Override
            boolean isWordDelimiter(ArgumentCommandNode<?, ?> node, char ch, int pos) {
                return !(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '\t' || ch == '_' || ch == '$');
            }
        }
        ,
        NERDY(false){

            @Override
            boolean isWordDelimiter(ArgumentCommandNode<?, ?> node, char ch, int pos) {
                return ch == ' ' || ch == '=' || ch == '.' || ch == ',' || ch == '[' || ch == ']' || ch == '(' || ch == ')' || ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '#' || ch == ':';
            }
        }
        ,
        NORMAL(true){

            @Override
            boolean isWordDelimiter(ArgumentCommandNode<?, ?> node, char ch, int pos) {
                if (!(node instanceof ArgumentCommandNode)) {
                    return VANILLA.isWordDelimiter(node, ch, pos);
                }
                ArgumentType argType = node.getType();
                if (argType instanceof class_2186) {
                    return ch == ' ' || ch == '[' || ch == ',' || ch == '=' || ch == ':' || ch == ']';
                }
                if (argType instanceof class_2181 || argType instanceof class_2188 || argType instanceof class_2232 || argType instanceof class_2223) {
                    return ch == ' ' || ch == ':' || ch == '/';
                }
                if (argType instanceof class_2293 || argType instanceof class_2287 || argType instanceof class_2179 || argType instanceof class_2212 || argType instanceof class_2178 || argType instanceof class_2257) {
                    return ch == ' ' || ch == '{' || ch == '=' || ch == '}' || ch == ',' || ch == '[' || ch == ':' || ch == ']';
                }
                if (argType instanceof class_2240 || argType instanceof class_2239) {
                    return ch == ' ' || ch == '.';
                }
                if (argType instanceof class_2203) {
                    return ch == ' ' || ch == '.' || ch == '[' || ch == ']';
                }
                if (argType instanceof class_2216) {
                    return ch == ' ' || ch == ':' || ch == '.';
                }
                if (argType instanceof AccessingPathArgumentType) {
                    return ch == ' ' || ch == '.' || ch == ',' || ch == '(' || ch == '!' || ch == '/' || ch == '#' || ch == '[' || ch == '<' || ch == ':' || ch == ')' || ch == ']' || ch == '>';
                }
                return VANILLA.isWordDelimiter(node, ch, pos);
            }
        }
        ,
        GREEDY(true){

            @Override
            boolean isWordDelimiter(ArgumentCommandNode<?, ?> node, char ch, int pos) {
                return ch >= 'A' && ch <= 'Z' || NORMAL.isWordDelimiter(node, ch, pos);
            }
        }
        ,
        CUSTOM(false){

            @Override
            boolean isWordDelimiter(ArgumentCommandNode<?, ?> node, char ch, int pos) {
                return OptionManager.smartCursorCustomWordDelimiters.contains(ch);
            }
        };

        protected final boolean shouldParseCommand;

        abstract boolean isWordDelimiter(ArgumentCommandNode<?, ?> var1, char var2, int var3);

        private CursorMode(boolean shouldParseCommand) {
            this.shouldParseCommand = shouldParseCommand;
        }

        public static class Parser
        extends EnumParser<CursorMode> {
            public Parser() {
                super(CursorMode.class);
            }
        }
    }

    public static class CharSetParser
    implements OptionParser<CharSet> {
        @Override
        public CharSet tryParse(String str) throws InvalidOptionException {
            CharOpenHashSet set = new CharOpenHashSet();
            for (char c : str.toCharArray()) {
                set.add(c);
            }
            return set;
        }

        @Override
        public String serialize(CharSet val) {
            StringBuilder sb = new StringBuilder();
            val.forEach(c -> sb.append((char)c));
            return sb.toString();
        }
    }
}

