/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util;

import java.lang.reflect.Field;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.log.entity.EntityLogColumn;
import lovexyn0827.mess.rendering.hud.data.BuiltinHudInfo;
import lovexyn0827.mess.rendering.hud.data.HudLine;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.phase.TickingPhase;
import net.minecraft.class_1297;

public class ListenedField
implements HudLine,
Comparable<HudLine> {
    protected final Field field;
    protected final String name;
    protected final AccessingPath path;

    public ListenedField(Field field, AccessingPath path, String customName) {
        this.field = field;
        this.name = customName != null ? customName : MessMod.INSTANCE.getMapping().namedField(this.field.getName());
        this.path = path != null ? path : AccessingPath.DUMMY;
    }

    @Override
    public boolean canGetFrom(class_1297 entity) {
        return Reflection.hasField(entity.getClass(), this.field);
    }

    public String get(class_1297 entity) {
        try {
            this.field.setAccessible(true);
            Object ob = this.field.get(entity);
            Object result = this.path.access(ob, this.field.getGenericType());
            return result != null ? result.toString() : "[null]";
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        catch (AccessingFailureException e) {
            return e.getShortenedMsg();
        }
    }

    @Override
    public String getFrom(class_1297 in) {
        return this.get(in);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == ListenedField.class) {
            ListenedField other = (ListenedField)obj;
            return this.field.equals(other.field) && this.path.equals(other.path);
        }
        return false;
    }

    @Override
    public int compareTo(HudLine o) {
        if (o instanceof BuiltinHudInfo) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.name + '(' + this.field.getName() + '.' + this.path + ')';
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Phased
    extends ListenedField
    implements EntityLogColumn {
        public final TickingPhase phase;

        public Phased(Field field, AccessingPath path, String customName, TickingPhase phase) {
            super(field, path, customName);
            this.phase = phase;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Phased) {
                Phased other = (Phased)obj;
                return this.field.equals(other.field) && this.path.equals(other.path) && this.phase.equals(other.phase);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.phase.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return this.name + '(' + this.field.getName() + '.' + this.path + '@' + this.phase + ')';
        }

        @Override
        public TickingPhase getPhase() {
            return this.phase;
        }
    }
}

