/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util;

import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import lovexyn0827.mess.options.EnumParser;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.ServerMicroTime;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;

public final class PulseRecorder {
    private final Object2BooleanMap<class_2338> activationStates = new Object2BooleanOpenHashMap();
    private final Object2ObjectMap<class_2338, ServerMicroTime> lastChangeTimes = new Object2ObjectOpenHashMap();

    public Optional<Pulse> setSignalLevel(class_2338 pos, boolean activated) {
        if (!this.activationStates.containsKey((Object)pos)) {
            this.activationStates.put((Object)pos, activated);
            this.lastChangeTimes.put((Object)pos, (Object)ServerMicroTime.current());
            return Optional.empty();
        }
        if (this.activationStates.getBoolean((Object)pos) ^ activated) {
            Pulse pulse = new Pulse(pos, !activated);
            this.activationStates.put((Object)pos, activated);
            this.lastChangeTimes.put((Object)pos, (Object)ServerMicroTime.current());
            if (OptionManager.fletchingTablePulseDetectingMode.shouldRecordPulse.test((Object)pulse)) {
                return Optional.of(pulse);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public class Pulse {
        public final boolean positive;
        public final class_2338 pos;
        public final long length;
        public final ServerMicroTime start;
        public final ServerMicroTime end;

        protected Pulse(class_2338 pos, boolean positive) {
            this.positive = positive;
            this.pos = pos;
            this.start = (ServerMicroTime)PulseRecorder.this.lastChangeTimes.get((Object)pos);
            this.end = ServerMicroTime.current();
            this.length = this.end.gameTime - this.start.gameTime;
        }

        public class_2561 toText() {
            class_2585 text = new class_2585(this.positive ? "+" : "-");
            String details = String.format("From: %d#%s\nTo: %d#%s\nAt: (%d, %d, %d)", this.start.gameTime, this.start.phase == null ? "?" : this.start.phase.name(), this.end.gameTime, this.end.phase == null ? "?" : this.end.phase.name(), this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260());
            class_2568 he = new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(details));
            text.method_27695(new class_124[]{class_124.field_1067, this.positive ? class_124.field_1061 : class_124.field_1078});
            text.method_10852((class_2561)new class_2585(Long.toString(this.length)).method_27692(class_124.field_1070).method_27696(class_2583.field_24360.method_10949(he)));
            return text;
        }
    }

    public static enum Mode {
        POSITIVE((Object2BooleanFunction<Pulse>)((Object2BooleanFunction)p -> ((Pulse)p).positive)),
        NEGATIVE((Object2BooleanFunction<Pulse>)((Object2BooleanFunction)p -> !((Pulse)p).positive)),
        BOTH((Object2BooleanFunction<Pulse>)((Object2BooleanFunction)p -> true));

        protected final Object2BooleanFunction<Pulse> shouldRecordPulse;

        private Mode(Object2BooleanFunction<Pulse> shouldRecordPulse) {
            this.shouldRecordPulse = shouldRecordPulse;
        }

        public static class Parser
        extends EnumParser<Mode> {
            public Parser() {
                super(Mode.class);
            }
        }
    }
}

