/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import lovexyn0827.mess.util.ArgumentListTokenizer;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.BytecodeHelper;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.Literal;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.NodeCompiler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;

public class LiteralNode
extends Node {
    private Literal<?> literal;

    public LiteralNode(String nodeStr) throws CommandSyntaxException {
        this.literal = Literal.parse(new ArgumentListTokenizer(nodeStr).next());
    }

    @Override
    Object access(Object previous) throws AccessingFailureException {
        try {
            return this.literal.get(this.outputType);
        }
        catch (InvalidLiteralException e) {
            throw AccessingFailureException.create(e, (Node)this);
        }
    }

    @Override
    protected Type resolveOutputType(Type lastOutType) throws AccessingFailureException, InvalidLiteralException {
        Object ob = this.literal.get(null);
        return ob == null ? Object.class : ob.getClass();
    }

    @Override
    void initialize(Type lastOutType) throws AccessingFailureException {
        try {
            this.literal.get(null);
        }
        catch (InvalidLiteralException e) {
            throw AccessingFailureException.create(e, (Node)this);
        }
        super.initialize(lastOutType);
    }

    @Override
    void uninitialize() {
        this.literal = this.literal.recreate();
    }

    @Override
    boolean allowsPrimitiveTypes() {
        return true;
    }

    @Override
    NodeCompiler getCompiler() {
        return ctx -> {
            InsnList insns = new InsnList();
            Type lastOut = ctx.getLastOutputType();
            insns.add((AbstractInsnNode)new InsnNode(lastOut == Double.TYPE || lastOut == Long.TYPE ? 88 : 87));
            BytecodeHelper.appendConstantLoader(ctx, insns, this.literal, Reflection.getRawType(this.outputType));
            ctx.endNode(this.outputType);
            return insns;
        };
    }
}

