/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import java.lang.reflect.Type;
import java.util.Set;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.NodeCompiler;
import org.jetbrains.annotations.Nullable;

abstract class Node {
    @Nullable
    protected Type outputType;
    private boolean initialized;
    int ordinary;
    protected Type inputType;

    Node() {
    }

    boolean canFollow(Node n) {
        return n.outputType != null && !Reflection.isPrimitive(n.outputType);
    }

    abstract Object access(Object var1) throws AccessingFailureException;

    Set<String> listSuggestions() {
        if (this.outputType != null) {
            // empty if block
        }
        return null;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    void initialize(Type lastOutClass) throws AccessingFailureException {
        try {
            this.outputType = this.resolveOutputType(lastOutClass);
        }
        catch (InvalidLiteralException e) {
            throw AccessingFailureException.create(e, this);
        }
        this.initialized = true;
        this.inputType = lastOutClass;
    }

    void uninitialize() {
        this.outputType = null;
        this.initialized = false;
    }

    protected abstract Type resolveOutputType(Type var1) throws AccessingFailureException, InvalidLiteralException;

    Node createCopyForInput(Object input) {
        return this;
    }

    boolean isWrittable() {
        return false;
    }

    void write(Object writeTo, Object newValue) throws AccessingFailureException {
        throw AccessingFailureException.create(FailureCause.NOT_WRITTABLE, this);
    }

    protected void ensureInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Called before initialization!");
        }
    }

    abstract NodeCompiler getCompiler();

    boolean allowsPrimitiveTypes() {
        return false;
    }
}

