/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.blame;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedList;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.blame.AnalyzedCause;
import lovexyn0827.mess.util.blame.Cause;
import lovexyn0827.mess.util.blame.StackTraceCause;
import lovexyn0827.mess.util.blame.TraceElement;
import org.jetbrains.annotations.Nullable;

public final class StackTrace {
    private final LinkedList<TraceElement> lines;

    public StackTrace(StackTraceElement[] elements) {
        this.lines = new LinkedList();
        for (StackTraceElement e : elements) {
            this.lines.add(TraceElement.from(e));
        }
    }

    private StackTrace(TraceElement[] elements) {
        this.lines = new LinkedList(Lists.newArrayList((Object[])elements));
    }

    public static StackTrace current() {
        return new StackTrace(Thread.currentThread().getStackTrace()).trim();
    }

    private StackTrace trim() {
        this.lines.removeLast();
        return this;
    }

    @Nullable
    public Cause blame() {
        switch (OptionManager.blamingMode) {
            case DISABLED: {
                return null;
            }
            case SIMPLE_TRACE: {
                return new StackTraceCause(this, false);
            }
            case DEOBFUSCATED_TRACE: {
                return new StackTraceCause(this.mapToNamed(), true);
            }
            case ANALYZED: {
                HashSet<AnalyzedCause.Clue> clues = new HashSet<AnalyzedCause.Clue>();
                this.lines.forEach(l -> clues.addAll(l.blame()));
                return new AnalyzedCause(clues);
            }
        }
        throw new IllegalStateException("Unrecognized blaming mode");
    }

    @Nullable
    public static Cause blameCurrent() {
        switch (OptionManager.blamingMode) {
            case DISABLED: {
                return null;
            }
            case SIMPLE_TRACE: {
                return new StackTraceCause(StackTrace.current().trim(), false);
            }
            case DEOBFUSCATED_TRACE: {
                return new StackTraceCause(StackTrace.current().trim(), true);
            }
            case ANALYZED: {
                HashSet<AnalyzedCause.Clue> clues = new HashSet<AnalyzedCause.Clue>();
                StackTrace.current().trim().lines.forEach(l -> clues.addAll(l.blame()));
                return new AnalyzedCause(clues);
            }
        }
        throw new IllegalStateException("Unrecognized blaming mode");
    }

    StackTrace mapToNamed() {
        return new StackTrace((TraceElement[])this.lines.stream().map(TraceElement::mapToNamed).toArray(TraceElement[]::new));
    }

    public String toString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (TraceElement e : this.lines) {
            sb.append(e.className).append('.').append(e.methodName).append('@').append(e.lineNum < 0 ? "?" : Integer.toString(e.lineNum)).append(delimiter);
        }
        return sb.substring(0, Math.max(0, sb.length() - 2));
    }

    public String toString() {
        return this.toString('\n');
    }
}

