/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rpg.item;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PotionVialItem
extends Item {
    public PotionVialItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41489_(new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_()));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 16;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11911_;
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        this.setDefaultSips(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!(level.f_46443_ || stack.m_41783_() != null && stack.m_41783_().m_128441_("SipsLeft"))) {
            this.setDefaultSips(stack);
        }
    }

    private void setDefaultSips(ItemStack stack) {
        stack.m_41784_().m_128405_("SipsLeft", 3);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41784_().m_128451_("SipsLeft") > 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.f_46443_) {
            MobEffect effect;
            CompoundTag tag = stack.m_41784_();
            String effectId = tag.m_128461_("PotionEffect");
            int duration = tag.m_128451_("Duration");
            int amplifier = tag.m_128451_("Amplifier");
            int sipsLeft = tag.m_128451_("SipsLeft");
            if (!effectId.isEmpty() && duration > 0 && (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectId))) != null) {
                int quarterDuration = duration / 3;
                MobEffectInstance effectInstance = effect.m_8093_() ? new MobEffectInstance(effect, 1, amplifier, false, true) : new MobEffectInstance(effect, quarterDuration, amplifier, false, true);
                entity.m_7292_(effectInstance);
            }
            sipsLeft = Math.max(0, sipsLeft - 1);
            tag.m_128405_("SipsLeft", sipsLeft);
            int modelData = switch (sipsLeft) {
                case 3 -> 0;
                case 2 -> 2;
                case 1 -> 3;
                default -> 3;
            };
            tag.m_128405_("CustomModelData", modelData);
            if (sipsLeft <= 0 && entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_150110_().f_35937_) {
                    return new ItemStack((ItemLike)Items.f_42590_);
                }
            }
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41784_();
        String effectId = tag.m_128461_("PotionEffect");
        int duration = tag.m_128451_("Duration");
        int amplifier = tag.m_128451_("Amplifier");
        if (!effectId.isEmpty() && duration > 0) {
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectId));
            if (effect != null) {
                MutableComponent effectName = Component.m_237115_((String)effect.m_19481_());
                TextColor color = effect.m_19486_() ? TextColor.m_131266_((int)0x3366FF) : TextColor.m_131266_((int)0xFF3333);
                tooltip.add((Component)effectName.m_130938_(style -> style.m_131148_(color)));
                int displayedDuration = duration / 20;
                tooltip.add((Component)Component.m_237113_((String)("Amplifier: " + (amplifier + 1))).m_130938_(style -> style.m_131148_(color)));
                tooltip.add((Component)Component.m_237113_((String)("Duration: " + displayedDuration + "s")).m_130938_(style -> style.m_131148_(color)));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Empty vial"));
        }
    }

    public Component m_7626_(ItemStack stack) {
        MobEffect effect;
        CompoundTag tag = stack.m_41784_();
        String effectId = tag.m_128461_("PotionEffect");
        String baseName = "Vial of ";
        if (!effectId.isEmpty() && (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effectId))) != null) {
            MutableComponent effectName = Component.m_237115_((String)effect.m_19481_());
            return Component.m_237113_((String)baseName).m_7220_((Component)effectName);
        }
        return Component.m_237113_((String)"Empty vial");
    }
}

