/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rpg.network;

import java.util.function.Supplier;
import net.mcreator.rpg.RpgMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RpgModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        RpgMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.swim_speed = message.data.swim_speed;
                    variables.movement_speed = message.data.movement_speed;
                    variables.modifierspeedcoil = message.data.modifierspeedcoil;
                    variables.modifierjavelin = message.data.modifierjavelin;
                    variables.modifierhandonastick = message.data.modifierhandonastick;
                    variables.modifiergravitycoil = message.data.modifiergravitycoil;
                    variables.MaxMana = message.data.MaxMana;
                    variables.max_health = message.data.max_health;
                    variables.ManaSpeed = message.data.ManaSpeed;
                    variables.ManaRegen = message.data.ManaRegen;
                    variables.ManaMultiplier = message.data.ManaMultiplier;
                    variables.Mana = message.data.Mana;
                    variables.MagicAttackMultiplier = message.data.MagicAttackMultiplier;
                    variables.entity_reach = message.data.entity_reach;
                    variables.entity_gravity = message.data.entity_gravity;
                    variables.block_reach = message.data.block_reach;
                    variables.attack_speed = message.data.attack_speed;
                    variables.attack_knockback = message.data.attack_knockback;
                    variables.attack_damage = message.data.attack_damage;
                    variables.drill_modiefier = message.data.drill_modiefier;
                    variables.powerup = message.data.powerup;
                    variables.max_jet = message.data.max_jet;
                    variables.jet = message.data.jet;
                    variables.critical_hit_chance = message.data.critical_hit_chance;
                    variables.ranged_critical_hit_chance = message.data.ranged_critical_hit_chance;
                    variables.proj_speed_multiplier = message.data.proj_speed_multiplier;
                    variables.ammo_consumption_chance = message.data.ammo_consumption_chance;
                    variables.proj_damage_multiplier = message.data.proj_damage_multiplier;
                    variables.rage_horn_multiplier = message.data.rage_horn_multiplier;
                    variables.pre_horn_multiplier = message.data.pre_horn_multiplier;
                    variables.blaze_helmet_crit = message.data.blaze_helmet_crit;
                    variables.blaze_boot_sprint_mod = message.data.blaze_boot_sprint_mod;
                    variables.mini_shield_speed = message.data.mini_shield_speed;
                    variables.mana_regen_necromancer = message.data.mana_regen_necromancer;
                    variables.seedsman = message.data.seedsman;
                    variables.velocity = message.data.velocity;
                    variables.giant_sword_modifier = message.data.giant_sword_modifier;
                    variables.OsmiumBallsModifier = message.data.OsmiumBallsModifier;
                    variables.lookx = message.data.lookx;
                    variables.looky = message.data.looky;
                    variables.lookz = message.data.lookz;
                    variables.heat = message.data.heat;
                    variables.maxheat = message.data.maxheat;
                    variables.heatcounter = message.data.heatcounter;
                    variables.flashbang = message.data.flashbang;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double swim_speed = 1.0;
        public double movement_speed = 0.1;
        public double modifierspeedcoil = 0.0;
        public double modifierjavelin = 0.0;
        public double modifierhandonastick = 0.0;
        public double modifiergravitycoil = 0.0;
        public double MaxMana = 20.0;
        public double max_health = 20.0;
        public double ManaSpeed = 30.0;
        public double ManaRegen = 0.0;
        public double ManaMultiplier = 1.0;
        public double Mana = 20.0;
        public double MagicAttackMultiplier = 1.0;
        public double entity_reach = 3.0;
        public double entity_gravity = 0.08;
        public double block_reach = 4.5;
        public double attack_speed = 4.0;
        public double attack_knockback = 0.0;
        public double attack_damage = 1.0;
        public double drill_modiefier = 0.0;
        public double powerup = 0.0;
        public double max_jet = 3.0;
        public double jet = 3.0;
        public double critical_hit_chance = 0.02;
        public double ranged_critical_hit_chance = 0.02;
        public double proj_speed_multiplier = 0.0;
        public double ammo_consumption_chance = 0.0;
        public double proj_damage_multiplier = 0.0;
        public double rage_horn_multiplier = 0.0;
        public double pre_horn_multiplier = 0.0;
        public double blaze_helmet_crit = 0.0;
        public double blaze_boot_sprint_mod = 0.0;
        public double mini_shield_speed = 0.0;
        public double mana_regen_necromancer = 0.0;
        public double seedsman = 0.0;
        public double velocity = 0.0;
        public double giant_sword_modifier = 0.0;
        public double OsmiumBallsModifier = 0.0;
        public double lookx = 0.0;
        public double looky = 0.0;
        public double lookz = 0.0;
        public double heat = 0.0;
        public double maxheat = 200.0;
        public double heatcounter = 0.0;
        public double flashbang = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                RpgMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("swim_speed", this.swim_speed);
            nbt.m_128347_("movement_speed", this.movement_speed);
            nbt.m_128347_("modifierspeedcoil", this.modifierspeedcoil);
            nbt.m_128347_("modifierjavelin", this.modifierjavelin);
            nbt.m_128347_("modifierhandonastick", this.modifierhandonastick);
            nbt.m_128347_("modifiergravitycoil", this.modifiergravitycoil);
            nbt.m_128347_("MaxMana", this.MaxMana);
            nbt.m_128347_("max_health", this.max_health);
            nbt.m_128347_("ManaSpeed", this.ManaSpeed);
            nbt.m_128347_("ManaRegen", this.ManaRegen);
            nbt.m_128347_("ManaMultiplier", this.ManaMultiplier);
            nbt.m_128347_("Mana", this.Mana);
            nbt.m_128347_("MagicAttackMultiplier", this.MagicAttackMultiplier);
            nbt.m_128347_("entity_reach", this.entity_reach);
            nbt.m_128347_("entity_gravity", this.entity_gravity);
            nbt.m_128347_("block_reach", this.block_reach);
            nbt.m_128347_("attack_speed", this.attack_speed);
            nbt.m_128347_("attack_knockback", this.attack_knockback);
            nbt.m_128347_("attack_damage", this.attack_damage);
            nbt.m_128347_("drill_modiefier", this.drill_modiefier);
            nbt.m_128347_("powerup", this.powerup);
            nbt.m_128347_("max_jet", this.max_jet);
            nbt.m_128347_("jet", this.jet);
            nbt.m_128347_("critical_hit_chance", this.critical_hit_chance);
            nbt.m_128347_("ranged_critical_hit_chance", this.ranged_critical_hit_chance);
            nbt.m_128347_("proj_speed_multiplier", this.proj_speed_multiplier);
            nbt.m_128347_("ammo_consumption_chance", this.ammo_consumption_chance);
            nbt.m_128347_("proj_damage_multiplier", this.proj_damage_multiplier);
            nbt.m_128347_("rage_horn_multiplier", this.rage_horn_multiplier);
            nbt.m_128347_("pre_horn_multiplier", this.pre_horn_multiplier);
            nbt.m_128347_("blaze_helmet_crit", this.blaze_helmet_crit);
            nbt.m_128347_("blaze_boot_sprint_mod", this.blaze_boot_sprint_mod);
            nbt.m_128347_("mini_shield_speed", this.mini_shield_speed);
            nbt.m_128347_("mana_regen_necromancer", this.mana_regen_necromancer);
            nbt.m_128347_("seedsman", this.seedsman);
            nbt.m_128347_("velocity", this.velocity);
            nbt.m_128347_("giant_sword_modifier", this.giant_sword_modifier);
            nbt.m_128347_("OsmiumBallsModifier", this.OsmiumBallsModifier);
            nbt.m_128347_("lookx", this.lookx);
            nbt.m_128347_("looky", this.looky);
            nbt.m_128347_("lookz", this.lookz);
            nbt.m_128347_("heat", this.heat);
            nbt.m_128347_("maxheat", this.maxheat);
            nbt.m_128347_("heatcounter", this.heatcounter);
            nbt.m_128347_("flashbang", this.flashbang);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.swim_speed = nbt.m_128459_("swim_speed");
            this.movement_speed = nbt.m_128459_("movement_speed");
            this.modifierspeedcoil = nbt.m_128459_("modifierspeedcoil");
            this.modifierjavelin = nbt.m_128459_("modifierjavelin");
            this.modifierhandonastick = nbt.m_128459_("modifierhandonastick");
            this.modifiergravitycoil = nbt.m_128459_("modifiergravitycoil");
            this.MaxMana = nbt.m_128459_("MaxMana");
            this.max_health = nbt.m_128459_("max_health");
            this.ManaSpeed = nbt.m_128459_("ManaSpeed");
            this.ManaRegen = nbt.m_128459_("ManaRegen");
            this.ManaMultiplier = nbt.m_128459_("ManaMultiplier");
            this.Mana = nbt.m_128459_("Mana");
            this.MagicAttackMultiplier = nbt.m_128459_("MagicAttackMultiplier");
            this.entity_reach = nbt.m_128459_("entity_reach");
            this.entity_gravity = nbt.m_128459_("entity_gravity");
            this.block_reach = nbt.m_128459_("block_reach");
            this.attack_speed = nbt.m_128459_("attack_speed");
            this.attack_knockback = nbt.m_128459_("attack_knockback");
            this.attack_damage = nbt.m_128459_("attack_damage");
            this.drill_modiefier = nbt.m_128459_("drill_modiefier");
            this.powerup = nbt.m_128459_("powerup");
            this.max_jet = nbt.m_128459_("max_jet");
            this.jet = nbt.m_128459_("jet");
            this.critical_hit_chance = nbt.m_128459_("critical_hit_chance");
            this.ranged_critical_hit_chance = nbt.m_128459_("ranged_critical_hit_chance");
            this.proj_speed_multiplier = nbt.m_128459_("proj_speed_multiplier");
            this.ammo_consumption_chance = nbt.m_128459_("ammo_consumption_chance");
            this.proj_damage_multiplier = nbt.m_128459_("proj_damage_multiplier");
            this.rage_horn_multiplier = nbt.m_128459_("rage_horn_multiplier");
            this.pre_horn_multiplier = nbt.m_128459_("pre_horn_multiplier");
            this.blaze_helmet_crit = nbt.m_128459_("blaze_helmet_crit");
            this.blaze_boot_sprint_mod = nbt.m_128459_("blaze_boot_sprint_mod");
            this.mini_shield_speed = nbt.m_128459_("mini_shield_speed");
            this.mana_regen_necromancer = nbt.m_128459_("mana_regen_necromancer");
            this.seedsman = nbt.m_128459_("seedsman");
            this.velocity = nbt.m_128459_("velocity");
            this.giant_sword_modifier = nbt.m_128459_("giant_sword_modifier");
            this.OsmiumBallsModifier = nbt.m_128459_("OsmiumBallsModifier");
            this.lookx = nbt.m_128459_("lookx");
            this.looky = nbt.m_128459_("looky");
            this.lookz = nbt.m_128459_("lookz");
            this.heat = nbt.m_128459_("heat");
            this.maxheat = nbt.m_128459_("maxheat");
            this.heatcounter = nbt.m_128459_("heatcounter");
            this.flashbang = nbt.m_128459_("flashbang");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("rpg", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.swim_speed = original.swim_speed;
            clone.movement_speed = original.movement_speed;
            clone.modifierspeedcoil = original.modifierspeedcoil;
            clone.modifierjavelin = original.modifierjavelin;
            clone.modifierhandonastick = original.modifierhandonastick;
            clone.modifiergravitycoil = original.modifiergravitycoil;
            clone.MaxMana = original.MaxMana;
            clone.max_health = original.max_health;
            clone.ManaSpeed = original.ManaSpeed;
            clone.ManaRegen = original.ManaRegen;
            clone.ManaMultiplier = original.ManaMultiplier;
            clone.Mana = original.Mana;
            clone.MagicAttackMultiplier = original.MagicAttackMultiplier;
            clone.entity_reach = original.entity_reach;
            clone.entity_gravity = original.entity_gravity;
            clone.block_reach = original.block_reach;
            clone.attack_speed = original.attack_speed;
            clone.attack_knockback = original.attack_knockback;
            clone.attack_damage = original.attack_damage;
            clone.drill_modiefier = original.drill_modiefier;
            clone.powerup = original.powerup;
            clone.max_jet = original.max_jet;
            clone.jet = original.jet;
            clone.critical_hit_chance = original.critical_hit_chance;
            clone.ranged_critical_hit_chance = original.ranged_critical_hit_chance;
            clone.proj_speed_multiplier = original.proj_speed_multiplier;
            clone.ammo_consumption_chance = original.ammo_consumption_chance;
            clone.proj_damage_multiplier = original.proj_damage_multiplier;
            clone.rage_horn_multiplier = original.rage_horn_multiplier;
            clone.pre_horn_multiplier = original.pre_horn_multiplier;
            clone.blaze_helmet_crit = original.blaze_helmet_crit;
            clone.blaze_boot_sprint_mod = original.blaze_boot_sprint_mod;
            clone.mini_shield_speed = original.mini_shield_speed;
            clone.mana_regen_necromancer = original.mana_regen_necromancer;
            clone.seedsman = original.seedsman;
            clone.velocity = original.velocity;
            clone.giant_sword_modifier = original.giant_sword_modifier;
            clone.OsmiumBallsModifier = original.OsmiumBallsModifier;
            clone.lookx = original.lookx;
            clone.looky = original.looky;
            clone.lookz = original.lookz;
            clone.heat = original.heat;
            clone.maxheat = original.maxheat;
            clone.heatcounter = original.heatcounter;
            clone.flashbang = original.flashbang;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

