/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.trailsandtalesplus.Objects.blocks;

import com.belgie.trailsandtalesplus.Objects.blocks.LumberryVines;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class LumBerryVinesBlock
extends Block
implements SimpleWaterloggedBlock,
LumberryVines,
BonemealableBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public LumBerryVinesBlock(BlockBehaviour.Properties p_54345_) {
        super(p_54345_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState p_54372_, BlockGetter p_54373_, BlockPos p_54374_, CollisionContext p_54375_) {
        switch ((Direction)p_54372_.getValue(FACING)) {
            case NORTH: {
                return SOUTH_AABB;
            }
            case SOUTH: {
                return NORTH_AABB;
            }
            case WEST: {
                return EAST_AABB;
            }
        }
        return WEST_AABB;
    }

    public static boolean canAttachTo(BlockGetter p_54349_, BlockPos p_54350_, Direction p_54351_) {
        BlockState blockstate = p_54349_.getBlockState(p_54350_);
        return blockstate.isFaceSturdy(p_54349_, p_54350_, p_54351_);
    }

    public boolean canSurvive(BlockState p_54353_, LevelReader p_54354_, BlockPos p_54355_) {
        Direction direction = (Direction)p_54353_.getValue(FACING);
        return LumBerryVinesBlock.canAttachTo((BlockGetter)p_54354_, p_54355_.relative(direction.getOpposite()), direction);
    }

    protected BlockState updateShape(BlockState p_54363_, LevelReader p_54366_, ScheduledTickAccess scheduledTickAccess, BlockPos p_54367_, Direction p_54364_, BlockPos p_54368_, BlockState p_54365_, RandomSource random) {
        if (p_54364_.getOpposite() == p_54363_.getValue(FACING) && !p_54363_.canSurvive(p_54366_, p_54367_)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)p_54363_.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(p_54367_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_54366_));
        }
        return super.updateShape(p_54363_, p_54366_, scheduledTickAccess, p_54367_, p_54364_, p_54368_, p_54365_, random);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_54347_) {
        BlockState blockstate;
        if (!p_54347_.replacingClickedOnBlock() && (blockstate = p_54347_.getLevel().getBlockState(p_54347_.getClickedPos().relative(p_54347_.getClickedFace().getOpposite()))).is((Block)this) && blockstate.getValue(FACING) == p_54347_.getClickedFace()) {
            return null;
        }
        BlockState blockstate1 = this.defaultBlockState();
        Level levelreader = p_54347_.getLevel();
        BlockPos blockpos = p_54347_.getClickedPos();
        FluidState fluidstate = p_54347_.getLevel().getFluidState(p_54347_.getClickedPos());
        for (Direction direction : p_54347_.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockstate1 = (BlockState)blockstate1.setValue(FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate1.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    public BlockState rotate(BlockState p_54360_, Rotation p_54361_) {
        return (BlockState)p_54360_.setValue(FACING, (Comparable)p_54361_.rotate((Direction)p_54360_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_54357_, Mirror p_54358_) {
        return p_54357_.rotate(p_54358_.getRotation((Direction)p_54357_.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54370_) {
        p_54370_.add(new Property[]{FACING, WATERLOGGED, BERRIES});
    }

    public FluidState getFluidState(BlockState p_54377_) {
        return (Boolean)p_54377_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_54377_);
    }

    protected InteractionResult useWithoutItem(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, BlockHitResult p_60508_) {
        return LumberryVines.use((Entity)p_60506_, p_60503_, p_60504_, p_60505_);
    }

    public void randomTick(BlockState p_222563_, ServerLevel p_222564_, BlockPos p_222565_, RandomSource p_222566_) {
        boolean i = (Boolean)p_222563_.getValue((Property)BERRIES);
        if (p_222564_.random.nextInt(4) == 0 && p_222564_.isAreaLoaded(p_222565_, 4) && !i) {
            BlockState blockstate = (BlockState)p_222563_.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true));
            p_222564_.setBlock(p_222565_, blockstate, 2);
            p_222564_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_222565_, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.fireCropGrowPost((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_);
        }
    }

    public boolean isValidBonemealTarget(LevelReader p_256026_, BlockPos p_152971_, BlockState p_152972_) {
        return (Boolean)p_152972_.getValue((Property)BERRIES) == false;
    }

    public boolean isBonemealSuccess(Level p_220930_, RandomSource p_220931_, BlockPos p_220932_, BlockState p_220933_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_220923_, RandomSource p_220924_, BlockPos p_220925_, BlockState p_220926_) {
        p_220923_.setBlock(p_220925_, (BlockState)p_220926_.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }
}

