/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.blocks;

import com.belgieyt.trailsandtalesplus.Objects.blocks.blockentity.BannerShelfBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class BannerShelfBlock
extends BaseEntityBlock {
    public static final MapCodec<BannerShelfBlock> CODEC = RecordCodecBuilder.mapCodec(p_309276_ -> p_309276_.group((App)Codec.BOOL.fieldOf("vertical").forGetter(p_309275_ -> p_309275_.vertical), (App)BannerShelfBlock.propertiesCodec()).apply((Applicative)p_309276_, BannerShelfBlock::new));
    private static final int MAX_BOOKS_IN_STORAGE = 9;
    public static final int BOOKS_PER_ROW = 3;
    public static final BooleanProperty SLOT_0_OCCUPIED = BlockStateProperties.SLOT_0_OCCUPIED;
    public static final BooleanProperty SLOT_1_OCCUPIED = BlockStateProperties.SLOT_1_OCCUPIED;
    public static final BooleanProperty SLOT_2_OCCUPIED = BlockStateProperties.SLOT_2_OCCUPIED;
    public static final BooleanProperty SLOT_3_OCCUPIED = BlockStateProperties.SLOT_3_OCCUPIED;
    public static final BooleanProperty SLOT_4_OCCUPIED = BlockStateProperties.SLOT_4_OCCUPIED;
    public static final BooleanProperty SLOT_5_OCCUPIED = BlockStateProperties.SLOT_5_OCCUPIED;
    public static final List<BooleanProperty> SLOT_OCCUPIED_PROPERTIES = List.of(SLOT_0_OCCUPIED, SLOT_1_OCCUPIED, SLOT_2_OCCUPIED, SLOT_3_OCCUPIED, SLOT_4_OCCUPIED, SLOT_5_OCCUPIED);
    public ResourceLocation items;
    public boolean vertical;

    public MapCodec<BannerShelfBlock> codec() {
        return CODEC;
    }

    public BannerShelfBlock(boolean bo, BlockBehaviour.Properties p_249989_) {
        super(p_249989_);
        BlockState $$1 = (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH);
        for (BooleanProperty $$2 : SLOT_OCCUPIED_PROPERTIES) {
            $$1 = (BlockState)$$1.setValue((Property)$$2, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState($$1);
    }

    protected RenderShape getRenderShape(BlockState p_251274_) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useItemOn(ItemStack p_336113_, BlockState p_329797_, Level p_331003_, BlockPos p_335104_, Player p_334454_, InteractionHand p_336011_, BlockHitResult p_329086_) {
        BlockEntity var9 = p_331003_.getBlockEntity(p_335104_);
        if (var9 instanceof BannerShelfBlockEntity) {
            BannerShelfBlockEntity $$8 = (BannerShelfBlockEntity)var9;
            if (!p_336113_.has(DataComponents.PROVIDES_BANNER_PATTERNS)) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            OptionalInt $$9 = this.getHitSlot(p_329086_, p_329797_);
            if ($$9.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (((Boolean)p_329797_.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get($$9.getAsInt()))).booleanValue()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            BannerShelfBlock.addBook(p_331003_, p_335104_, p_334454_, $$8, p_336113_, $$9.getAsInt());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult useWithoutItem(BlockState p_335003_, Level p_333933_, BlockPos p_333604_, Player p_334275_, BlockHitResult p_334482_) {
        BlockEntity var7 = p_333933_.getBlockEntity(p_333604_);
        if (var7 instanceof BannerShelfBlockEntity) {
            BannerShelfBlockEntity $$6 = (BannerShelfBlockEntity)var7;
            OptionalInt $$7 = this.getHitSlot(p_334482_, p_335003_);
            if ($$7.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!((Boolean)p_335003_.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get($$7.getAsInt()))).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            BannerShelfBlock.removeBook(p_333933_, p_333604_, p_334275_, $$6, $$7.getAsInt());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private OptionalInt getHitSlot(BlockHitResult p_333742_, BlockState p_330398_) {
        return BannerShelfBlock.getRelativeHitCoordinatesForBlockFace(p_333742_, (Direction)p_330398_.getValue((Property)HorizontalDirectionalBlock.FACING)).map(p_327255_ -> {
            int $$1 = p_327255_.y >= 0.5f ? 0 : 1;
            int $$2 = BannerShelfBlock.getSection(p_327255_.x);
            return OptionalInt.of($$2 + $$1 * 3);
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult p_261714_, Direction p_262116_) {
        Direction $$2 = p_261714_.getDirection();
        if (p_262116_ != $$2) {
            return Optional.empty();
        }
        BlockPos $$3 = p_261714_.getBlockPos().relative($$2);
        Vec3 $$4 = p_261714_.getLocation().subtract((double)$$3.getX(), (double)$$3.getY(), (double)$$3.getZ());
        double $$5 = $$4.x();
        double $$6 = $$4.y();
        double $$7 = $$4.z();
        return switch ($$2) {
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - $$5), (float)$$6));
            case Direction.SOUTH -> Optional.of(new Vec2((float)$$5, (float)$$6));
            case Direction.WEST -> Optional.of(new Vec2((float)$$7, (float)$$6));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - $$7), (float)$$6));
            case Direction.DOWN, Direction.UP -> Optional.empty();
            default -> throw new MatchException(null, null);
        };
    }

    private static int getSection(float p_261599_) {
        float $$1 = 0.0625f;
        float $$2 = 0.375f;
        if (p_261599_ < 0.375f) {
            return 0;
        }
        float $$3 = 0.6875f;
        return p_261599_ < 0.6875f ? 1 : 2;
    }

    private static void addBook(Level p_262592_, BlockPos p_262669_, Player p_262572_, BannerShelfBlockEntity p_262606_, ItemStack p_262587_, int p_262692_) {
        if (!p_262592_.isClientSide()) {
            p_262572_.awardStat(Stats.ITEM_USED.get((Object)p_262587_.getItem()));
            SoundEvent $$6 = p_262587_.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_INSERT;
            p_262606_.setItem(p_262692_, p_262587_.consumeAndReturn(1, (LivingEntity)p_262572_));
            p_262592_.playSound((Entity)((Player)null), p_262669_, $$6, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void removeBook(Level p_262654_, BlockPos p_262601_, Player p_262636_, BannerShelfBlockEntity p_262605_, int p_262673_) {
        if (!p_262654_.isClientSide()) {
            ItemStack $$5 = p_262605_.removeItem(p_262673_, 1);
            SoundEvent $$6 = $$5.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_PICKUP;
            p_262654_.playSound((Entity)((Player)null), p_262601_, $$6, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!p_262636_.getInventory().add($$5)) {
                p_262636_.drop($$5, false);
            }
            p_262654_.gameEvent((Entity)p_262636_, (Holder)GameEvent.BLOCK_CHANGE, p_262601_);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_250440_, BlockState p_248729_) {
        return new BannerShelfBlockEntity(p_250440_, p_248729_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_250973_) {
        p_250973_.add(new Property[]{HorizontalDirectionalBlock.FACING});
        List<BooleanProperty> var10000 = SLOT_OCCUPIED_PROPERTIES;
        Objects.requireNonNull(p_250973_);
        var10000.forEach(p_261456_ -> p_250973_.add(new Property[]{(Property)p_261456_}));
    }

    protected void affectNeighborsAfterRemoval(BlockState p_394831_, ServerLevel p_397362_, BlockPos p_395293_, boolean p_394170_) {
        Containers.updateNeighboursAfterDestroy((BlockState)p_394831_, (Level)p_397362_, (BlockPos)p_395293_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_251318_) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)p_251318_.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState p_288975_, Rotation p_288993_) {
        return (BlockState)p_288975_.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)p_288993_.rotate((Direction)p_288975_.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState p_289000_, Mirror p_288962_) {
        return p_289000_.rotate(p_288962_.getRotation((Direction)p_289000_.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    protected boolean hasAnalogOutputSignal(BlockState p_249302_) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState p_249192_, Level p_252207_, BlockPos p_248999_, Direction p_426606_) {
        if (p_252207_.isClientSide()) {
            return 0;
        }
        BlockEntity var5 = p_252207_.getBlockEntity(p_248999_);
        if (var5 instanceof BannerShelfBlockEntity) {
            BannerShelfBlockEntity $$3 = (BannerShelfBlockEntity)var5;
            return $$3.getLastInteractedSlot() + 1;
        }
        return 0;
    }
}

