/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.blocks.blockentity;

import com.belgieyt.trailsandtalesplus.Objects.TTBlockEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.blocks.BannerShelfBlock;
import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BannerShelfBlockEntity
extends BlockEntity
implements Container {
    public static final int MAX_BOOKS_IN_STORAGE = 9;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private int lastInteractedSlot = -1;
    private LazyOptional<?> itemHandler = LazyOptional.of(this::createUnSidedHandler);

    public BannerShelfBlockEntity(BlockPos p_249541_, BlockState p_251752_) {
        super((BlockEntityType)TTBlockEntityRegistry.BANNER_SHELF.get(), p_249541_, p_251752_);
    }

    private void updateState(int p_261806_) {
        if (p_261806_ >= 0 && p_261806_ < 9) {
            this.lastInteractedSlot = p_261806_;
            BlockState blockstate = this.getBlockState();
            for (int i = 0; i < BannerShelfBlock.SLOT_OCCUPIED_PROPERTIES.size(); ++i) {
                boolean flag = !this.getItem(i).isEmpty();
                BooleanProperty booleanproperty = BannerShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(i);
                blockstate = (BlockState)blockstate.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
            }
            Objects.requireNonNull(this.level).setBlock(this.worldPosition, blockstate, 3);
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.Context.of((BlockState)blockstate));
        } else {
            LOGGER.error("Expected slot 0-5, got {}", (Object)p_261806_);
        }
    }

    protected void loadAdditional(ValueInput p_410328_) {
        super.loadAdditional(p_410328_);
        this.items.clear();
        ContainerHelper.loadAllItems((ValueInput)p_410328_, this.items);
        this.lastInteractedSlot = p_410328_.getIntOr("last_interacted_slot", -1);
    }

    protected void saveAdditional(ValueOutput p_406157_) {
        super.saveAdditional(p_406157_);
        ContainerHelper.saveAllItems((ValueOutput)p_406157_, this.items, (boolean)true);
        p_406157_.putInt("last_interacted_slot", this.lastInteractedSlot);
    }

    public int count() {
        return (int)this.items.stream().filter(Predicate.not(ItemStack::isEmpty)).count();
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int p_256203_) {
        return (ItemStack)this.items.get(p_256203_);
    }

    public ItemStack removeItem(int p_255828_, int p_255673_) {
        ItemStack itemstack = Objects.requireNonNullElse((ItemStack)this.items.get(p_255828_), ItemStack.EMPTY);
        this.items.set(p_255828_, (Object)ItemStack.EMPTY);
        if (!itemstack.isEmpty()) {
            this.updateState(p_255828_);
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int p_255874_) {
        return this.removeItem(p_255874_, 1);
    }

    public void setItem(int p_256610_, ItemStack p_255789_) {
        if (p_255789_.has(DataComponents.PROVIDES_BANNER_PATTERNS)) {
            this.items.set(p_256610_, (Object)p_255789_);
            this.updateState(p_256610_);
        } else if (p_255789_.isEmpty()) {
            this.removeItem(p_256610_, 1);
        }
    }

    public boolean canTakeItem(Container p_282172_, int p_281387_, ItemStack p_283257_) {
        return p_282172_.hasAnyMatching(p_327306_ -> p_327306_.isEmpty() ? true : ItemStack.isSameItemSameComponents((ItemStack)p_283257_, (ItemStack)p_327306_) && p_327306_.getCount() + p_283257_.getCount() <= p_282172_.getMaxStackSize(p_327306_));
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(Player p_256481_) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)p_256481_);
    }

    public boolean canPlaceItem(int p_256567_, ItemStack p_255922_) {
        return p_255922_.has(DataComponents.PROVIDES_BANNER_PATTERNS) && this.getItem(p_256567_).isEmpty() && p_255922_.getCount() == this.getMaxStackSize();
    }

    public int getLastInteractedSlot() {
        return this.lastInteractedSlot;
    }

    protected void applyImplicitComponents(DataComponentGetter p_393028_) {
        super.applyImplicitComponents(p_393028_);
        ((ItemContainerContents)p_393028_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.items);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_331494_) {
        super.collectImplicitComponents(p_331494_);
        p_331494_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
    }

    public void removeComponentsFromTag(CompoundTag p_329882_) {
        p_329882_.remove("Items");
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((Container)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER && !this.remove ? this.itemHandler.cast() : super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(this::createUnSidedHandler);
    }
}

