/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity.model;

import com.belgieyt.trailsandtalesplus.Objects.entity.renderer.SniffleRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.animation.definitions.SnifferAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkeletonSnifferModel
extends EntityModel<SniffleRenderState> {
    private static final float WALK_ANIMATION_SPEED_MAX = 9.0f;
    private static final float WALK_ANIMATION_SCALE_FACTOR = 100.0f;
    private final ModelPart root;
    private final ModelPart head;
    private final KeyframeAnimation sniffSearchAnimation;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation digAnimation;
    private final KeyframeAnimation longSniffAnimation;
    private final KeyframeAnimation standUpAnimation;
    private final KeyframeAnimation happyAnimation;
    private final KeyframeAnimation sniffSniffAnimation;
    private final KeyframeAnimation babyTransform;

    public SkeletonSnifferModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.head = this.root.getChild("bone").getChild("body").getChild("head");
        this.sniffSearchAnimation = SnifferAnimation.SNIFFER_SNIFF_SEARCH.bake(root);
        this.walkAnimation = SnifferAnimation.SNIFFER_WALK.bake(root);
        this.digAnimation = SnifferAnimation.SNIFFER_DIG.bake(root);
        this.longSniffAnimation = SnifferAnimation.SNIFFER_LONGSNIFF.bake(root);
        this.standUpAnimation = SnifferAnimation.SNIFFER_STAND_UP.bake(root);
        this.happyAnimation = SnifferAnimation.SNIFFER_HAPPY.bake(root);
        this.sniffSniffAnimation = SnifferAnimation.SNIFFER_SNIFFSNIFF.bake(root);
        this.babyTransform = SnifferAnimation.BABY_TRANSFORM.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot().addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition $$2 = $$1.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(95, 76).addBox(-12.5f, 12.0f, -16.0f, 25.0f, 0.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 80).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 25.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 8).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 20.0f, 32.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 4).addBox(-6.5f, 7.5f, -11.5f, 13.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(8, 15).addBox(-6.5f, -7.5f, -11.5f, 13.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)-16.0f));
        PartDefinition lower_beak = head.addOrReplaceChild("lower_beak", CubeListBuilder.create().texOffs(15, 62).addBox(-6.5f, -7.0f, 1.0f, 13.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.5f, (float)-16.5f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(15, 50).addBox(-6.5f, -2.0f, 0.0f, 13.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-15.5f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(2, 0).addBox(0.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition front_left_leg = $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition front_right_leg = $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(32, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition back_left_leg = $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)15.0f));
        PartDefinition back_right_leg = $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(32, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)15.0f));
        PartDefinition leg1 = $$0.getRoot().addOrReplaceChild("right_mid_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition leg2 = $$0.getRoot().addOrReplaceChild("left_mid_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)$$0, (int)192, (int)192);
    }

    public static LayerDefinition createFur() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot().addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition $$2 = $$1.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(95, 76).addBox(-12.5f, 12.0f, -16.0f, 25.0f, 0.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 80).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 25.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 8).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 20.0f, 32.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 4).addBox(-6.5f, 7.5f, -11.5f, 13.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(8, 15).addBox(-6.5f, -7.5f, -11.5f, 13.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)-16.0f));
        PartDefinition lower_beak = head.addOrReplaceChild("lower_beak", CubeListBuilder.create().texOffs(15, 62).addBox(-6.5f, -7.0f, 1.0f, 13.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.5f, (float)-16.5f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(15, 50).addBox(-6.5f, -2.0f, 0.0f, 13.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-15.5f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(2, 0).addBox(0.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition front_left_leg = $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition front_right_leg = $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(32, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition back_left_leg = $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)15.0f));
        PartDefinition back_right_leg = $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(32, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)15.0f));
        PartDefinition leg1 = $$0.getRoot().addOrReplaceChild("right_mid_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition leg2 = $$0.getRoot().addOrReplaceChild("left_mid_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)$$0, (int)192, (int)192);
    }

    public static LayerDefinition createSkimLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot().addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition $$2 = $$1.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(95, 76).addBox(-12.5f, 12.0f, -16.0f, 25.0f, 0.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 80).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 25.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 8).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 20.0f, 32.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 4).addBox(-6.5f, 7.5f, -11.5f, 13.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(8, 15).addBox(-6.5f, -7.5f, -11.5f, 13.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)-16.0f));
        PartDefinition lower_beak = head.addOrReplaceChild("lower_beak", CubeListBuilder.create().texOffs(15, 62).addBox(-6.5f, -7.0f, 1.0f, 13.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.5f, (float)-16.5f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(15, 50).addBox(-6.5f, -2.0f, 0.0f, 13.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-15.5f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(2, 0).addBox(0.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition front_left_leg = $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition front_right_leg = $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(32, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition back_left_leg = $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)15.0f));
        PartDefinition back_right_leg = $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(32, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)15.0f));
        PartDefinition leg1 = $$0.getRoot().addOrReplaceChild("right_mid_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition leg2 = $$0.getRoot().addOrReplaceChild("left_mid_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)$$0, (int)192, (int)192);
    }

    public void setupAnim(SniffleRenderState p_363751_) {
        super.setupAnim((EntityRenderState)p_363751_);
        this.head.xRot = p_363751_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_363751_.yRot * ((float)Math.PI / 180);
        if (p_363751_.isSearching) {
            this.sniffSearchAnimation.applyWalk(p_363751_.walkAnimationPos, p_363751_.walkAnimationSpeed, 9.0f, 100.0f);
        } else {
            this.walkAnimation.applyWalk(p_363751_.walkAnimationPos, p_363751_.walkAnimationSpeed, 9.0f, 100.0f);
        }
        this.digAnimation.apply(p_363751_.diggingAnimationState, p_363751_.ageInTicks);
        this.longSniffAnimation.apply(p_363751_.sniffingAnimationState, p_363751_.ageInTicks);
        this.standUpAnimation.apply(p_363751_.risingAnimationState, p_363751_.ageInTicks);
        this.happyAnimation.apply(p_363751_.feelingHappyAnimationState, p_363751_.ageInTicks);
        this.sniffSniffAnimation.apply(p_363751_.scentingAnimationState, p_363751_.ageInTicks);
        if (p_363751_.isBaby) {
            this.babyTransform.applyStatic();
        }
    }
}

