/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.notjustnameplates;

import java.util.Map;
import java.util.UUID;
import me.youhavetrouble.notjustnameplates.NJNConfig;
import me.youhavetrouble.notjustnameplates.TeamManager;
import me.youhavetrouble.notjustnameplates.commands.MainCommand;
import me.youhavetrouble.notjustnameplates.displays.DisplayContent;
import me.youhavetrouble.notjustnameplates.nameplates.NameplateManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.permissions.DefaultPermissions;

public final class NotJustNameplates
extends JavaPlugin {
    private static NotJustNameplates instance;
    private static NJNConfig config;
    private static long time;
    private final TeamManager teamManager = new TeamManager();
    private NameplateManager nameplateManager = null;
    private static boolean papiHook;
    private static boolean superVanishHook;
    private static boolean vanishNoPacketHook;

    public void onEnable() {
        instance = this;
        config = new NJNConfig(this);
        this.checkHooks();
        DefaultPermissions.registerPermission((String)"notjustnameplates.seeown", (String)"Allows a player to see their own nameplate", (PermissionDefault)PermissionDefault.FALSE);
        DefaultPermissions.registerPermission((String)"notjustnameplates.command", (String)"Allows a player to use the /njn command", (PermissionDefault)PermissionDefault.TRUE);
        DefaultPermissions.registerPermission((String)"notjustnameplates.command.reload", (String)"Allows a player to use the /njn reload command", (PermissionDefault)PermissionDefault.OP);
        DefaultPermissions.registerPermission((String)"notjustnameplates.command.toggle", (String)"Allows a player to use the /njn toggle command", (PermissionDefault)PermissionDefault.TRUE);
        this.nameplateManager = new NameplateManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.nameplateManager, (Plugin)this);
        new MainCommand(this);
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            ++time;
            if (config == null) {
                return;
            }
            config.getDisplayContents().values().forEach(displayContent -> {
                if (displayContent == null) {
                    return;
                }
                if (displayContent.getRefreshRate() <= 0) {
                    return;
                }
                if (time % (long)displayContent.getRefreshRate() != 0L) {
                    return;
                }
                displayContent.advanceFrame();
            });
            if (time % 20L != 0L) {
                return;
            }
            this.updateNameplatesBasedOnPermission();
        }, 1L, 1L);
    }

    public void reloadPluginConfig() {
        config = new NJNConfig(this);
        this.checkHooks();
        this.nameplateManager.reloadNameplates();
        this.updateNameplatesBasedOnPermission();
    }

    private void updateNameplatesBasedOnPermission() {
        this.nameplateManager.getNameplates().forEach((uuid, nameplate) -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) {
                return;
            }
            nameplate.setContent(this.getDisplayContentForPlayerBasedOnPermission(player));
        });
    }

    public DisplayContent getDisplayContentForPlayerBasedOnPermission(Player player) {
        if (player == null) {
            return null;
        }
        for (Map.Entry<String, DisplayContent> entry : config.getDisplayContents().entrySet()) {
            String id = entry.getKey();
            if (id.equalsIgnoreCase("default") || !player.hasPermission("notjustnameplates.display." + id)) continue;
            return entry.getValue();
        }
        return config.getDisplayContent("default");
    }

    private void checkHooks() {
        papiHook = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        superVanishHook = Bukkit.getPluginManager().isPluginEnabled("SuperVanish") || Bukkit.getPluginManager().isPluginEnabled("PremiumVanish");
        vanishNoPacketHook = Bukkit.getPluginManager().isPluginEnabled("VanishNoPacket");
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public NameplateManager getNameplateManager() {
        return this.nameplateManager;
    }

    public static NotJustNameplates getInstance() {
        return instance;
    }

    public static long getTime() {
        return time;
    }

    public static NJNConfig getPluginConfig() {
        return config;
    }

    public static boolean isPapiHooked() {
        return papiHook;
    }

    public static boolean isSuperVanishHooked() {
        return superVanishHook;
    }

    public static boolean isVanishNoPacketHooked() {
        return vanishNoPacketHook;
    }

    static {
        time = Long.MIN_VALUE;
        vanishNoPacketHook = false;
    }
}

