/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.notjustnameplates;

import java.util.HashSet;
import java.util.Set;
import me.youhavetrouble.notjustnameplates.NotJustNameplates;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class TeamManager
implements Listener {
    private final Scoreboard scoreboard = new Scoreboard();
    private final PlayerTeam team = new PlayerTeam(this.scoreboard, "notjustnameplates");
    private final Set<String> players = new HashSet<String>();

    public TeamManager() {
        this.team.setNameTagVisibility(Team.Visibility.NEVER);
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (player.getLastSeen() <= System.currentTimeMillis() - 604800000L) continue;
            this.players.add(player.getName());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.players.add(player.getName())) {
            Bukkit.getOnlinePlayers().forEach(onlinePlayer -> this.sendAddPlayerToTeam(player, (Player)onlinePlayer));
        }
        this.sendTeamCreatePacket(player);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)NotJustNameplates.getInstance(), () -> this.sendTeamMembers(player));
    }

    public void sendTeamCreatePacket(@NotNull Player target) {
        CraftPlayer craftPlayer = (CraftPlayer)target;
        ClientboundSetPlayerTeamPacket teamCreatePacket = ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)this.team, (boolean)true);
        craftPlayer.getHandle().connection.send((Packet)teamCreatePacket);
    }

    private void sendAddPlayerToTeam(@NotNull Player player, @NotNull Player target) {
        CraftPlayer craftPlayer = (CraftPlayer)target;
        ClientboundSetPlayerTeamPacket packet = ClientboundSetPlayerTeamPacket.createPlayerPacket((PlayerTeam)this.team, (String)player.getName(), (ClientboundSetPlayerTeamPacket.Action)ClientboundSetPlayerTeamPacket.Action.ADD);
        craftPlayer.getHandle().connection.send((Packet)packet);
    }

    private void sendRemovePlayerFromTeam(@NotNull Player playerToRemove, @NotNull Player target) {
        ClientboundSetPlayerTeamPacket packet = ClientboundSetPlayerTeamPacket.createPlayerPacket((PlayerTeam)this.team, (String)playerToRemove.getName(), (ClientboundSetPlayerTeamPacket.Action)ClientboundSetPlayerTeamPacket.Action.REMOVE);
        CraftPlayer craftPlayer = (CraftPlayer)target;
        craftPlayer.getHandle().connection.send((Packet)packet);
    }

    private void sendTeamMembers(@NotNull Player target) {
        ClientboundSetPlayerTeamPacket packet = ClientboundSetPlayerTeamPacket.createMultiplePlayerPacket((PlayerTeam)this.team, this.players, (ClientboundSetPlayerTeamPacket.Action)ClientboundSetPlayerTeamPacket.Action.ADD);
        CraftPlayer craftPlayer = (CraftPlayer)target;
        craftPlayer.getHandle().connection.send((Packet)packet);
    }
}

