/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.notjustnameplates.nameplates;

import de.myzelyam.api.vanish.VanishAPI;
import java.util.UUID;
import me.youhavetrouble.notjustnameplates.NotJustNameplates;
import me.youhavetrouble.notjustnameplates.displays.DisplayContent;
import me.youhavetrouble.notjustnameplates.displays.DisplayFrame;
import me.youhavetrouble.notjustnameplates.text.TextParser;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.kitteh.vanish.VanishPlugin;

public class Nameplate {
    public static final NamespacedKey NAMEPLATE_KEY = new NamespacedKey((Plugin)NotJustNameplates.getInstance(), "nameplate");
    protected boolean forceHide = false;
    private DisplayContent content;
    public final UUID playerUuid;
    private TextDisplay.TextAlignment alignment = TextDisplay.TextAlignment.CENTER;
    private boolean visibleForOwner = false;
    private TextDisplay textDisplay;

    public Nameplate(@NotNull UUID playerUuid, DisplayContent content) {
        this.playerUuid = playerUuid;
        this.content = content;
    }

    protected TextDisplay getEntity() {
        return this.textDisplay;
    }

    private void createDisplayEntity() {
        DisplayFrame currentFrame;
        if (this.textDisplay != null && !this.textDisplay.isDead()) {
            return;
        }
        if (this.content == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.playerUuid);
        if (player == null) {
            return;
        }
        DisplayFrame displayFrame = currentFrame = player.isSneaking() && this.content.getCurrentFrame().sneakOverride() != null ? this.content.getCurrentFrame().sneakOverride() : this.content.getCurrentFrame();
        if (currentFrame.text() == null) {
            return;
        }
        this.textDisplay = (TextDisplay)player.getWorld().spawnEntity(player.getEyeLocation(), EntityType.TEXT_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, entity -> {
            TextDisplay textDisplay = (TextDisplay)entity;
            textDisplay.getPersistentDataContainer().set(NAMEPLATE_KEY, PersistentDataType.STRING, (Object)player.getName());
            textDisplay.setInvulnerable(true);
            textDisplay.setPersistent(false);
            textDisplay.setAlignment(this.alignment);
            textDisplay.setBillboard(this.content.getBillboard());
            textDisplay.setSeeThrough(this.content.getSeeThrough());
            textDisplay.setViewRange((float)this.content.getViewRange());
            textDisplay.setShadowRadius(0.0f);
            textDisplay.setInterpolationDuration(this.content.getInterpolationDuration());
            textDisplay.setInterpolationDelay(this.content.getInterpolationDelay());
            textDisplay.setShadowed(currentFrame.shadowed());
            textDisplay.setTextOpacity(currentFrame.textOpacity());
            Color backgroundColor = currentFrame.backgroundColor();
            if (backgroundColor != null) {
                textDisplay.setBackgroundColor(backgroundColor);
            }
            textDisplay.text(this.parseText(currentFrame.text(), player));
            textDisplay.setTransformation(new Transformation(currentFrame.offset(), new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f), currentFrame.scale(), new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f)));
            NotJustNameplates.getInstance().getNameplateManager().getPlayersWithNameplatesOff().forEach(uuid -> {
                Player playerWithNameplatesOff = Bukkit.getPlayer((UUID)uuid);
                if (playerWithNameplatesOff != null) {
                    playerWithNameplatesOff.hideEntity((Plugin)NotJustNameplates.getInstance(), (Entity)textDisplay);
                }
            });
        });
        if (!this.visibleForOwner) {
            player.hideEntity((Plugin)NotJustNameplates.getInstance(), (Entity)this.textDisplay);
        }
        player.addPassenger((Entity)this.textDisplay);
    }

    public void setContent(DisplayContent content) {
        if (content == null || this.content == content) {
            return;
        }
        this.content = content;
        Bukkit.getScheduler().runTask((Plugin)NotJustNameplates.getInstance(), this::remove);
    }

    public DisplayContent getContent() {
        return this.content;
    }

    public void setAlignment(@NotNull TextDisplay.TextAlignment alignment) {
        this.alignment = alignment;
        if (this.textDisplay == null || this.textDisplay.isDead()) {
            return;
        }
        this.textDisplay.setAlignment(alignment);
    }

    public TextDisplay.TextAlignment getAlignment() {
        return this.alignment;
    }

    public void setVisibleForOwner(boolean visible) {
        this.visibleForOwner = visible;
        if (this.textDisplay == null || this.textDisplay.isDead()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.playerUuid);
        if (player == null) {
            return;
        }
        if (visible) {
            player.showEntity((Plugin)NotJustNameplates.getInstance(), (Entity)this.textDisplay);
        } else {
            player.hideEntity((Plugin)NotJustNameplates.getInstance(), (Entity)this.textDisplay);
        }
    }

    public boolean isVisibleForOwner() {
        return this.visibleForOwner;
    }

    public void update() {
        DisplayFrame currentFrame;
        VanishPlugin vanishPlugin;
        if (this.forceHide) {
            this.remove();
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.playerUuid);
        if (player == null || player.isDead()) {
            this.remove();
            return;
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            this.remove();
            return;
        }
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            this.remove();
            return;
        }
        if (NotJustNameplates.isSuperVanishHooked() && VanishAPI.isInvisible((Player)player)) {
            this.remove();
            return;
        }
        if (NotJustNameplates.isVanishNoPacketHooked() && (vanishPlugin = (VanishPlugin)Bukkit.getPluginManager().getPlugin("VanishNoPacket")) != null && vanishPlugin.getManager().isVanished(player)) {
            this.remove();
            return;
        }
        if (this.content == null) {
            this.remove();
            return;
        }
        DisplayFrame displayFrame = currentFrame = player.isSneaking() && this.content.getCurrentFrame().sneakOverride() != null ? this.content.getCurrentFrame().sneakOverride() : this.content.getCurrentFrame();
        if (currentFrame.text() == null) {
            this.remove();
            return;
        }
        this.createDisplayEntity();
        if (this.textDisplay == null || this.textDisplay.isDead()) {
            return;
        }
        if (!player.getPassengers().contains(this.textDisplay)) {
            player.addPassenger((Entity)this.textDisplay);
        }
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer == player) continue;
            if (!onlinePlayer.canSee(player) && onlinePlayer.canSee((Entity)this.textDisplay)) {
                onlinePlayer.hideEntity((Plugin)NotJustNameplates.getInstance(), (Entity)this.textDisplay);
                continue;
            }
            if (!onlinePlayer.canSee(player) || onlinePlayer.canSee((Entity)this.textDisplay)) continue;
            onlinePlayer.showEntity((Plugin)NotJustNameplates.getInstance(), (Entity)this.textDisplay);
        }
        this.textDisplay.text(this.parseText(currentFrame.text(), player));
        this.textDisplay.setBillboard(this.content.getBillboard());
        this.textDisplay.setShadowed(currentFrame.shadowed());
        this.textDisplay.setTextOpacity(currentFrame.textOpacity());
        this.textDisplay.setTransformation(new Transformation(currentFrame.offset(), new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f), currentFrame.scale(), new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f)));
        Color backgroundColor = currentFrame.backgroundColor();
        if (backgroundColor == null) {
            this.textDisplay.setDefaultBackground(true);
        } else {
            this.textDisplay.setBackgroundColor(backgroundColor);
        }
        this.setVisibleForOwner(this.visibleForOwner || player.hasPermission("notjustnameplates.seeown"));
    }

    protected void remove() {
        if (this.textDisplay == null || this.textDisplay.isDead()) {
            return;
        }
        this.textDisplay.remove();
    }

    private Component parseText(String text, Player player) {
        if (player == null || !player.isOnline()) {
            return Component.empty();
        }
        return TextParser.parseWithPlaceholders(text, player);
    }
}

